/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.pqueue;

import java.util.Arrays;

public class BinHeap<T> {
    private static final double GROW_FACTOR = 2.0;
    private double[] prio;
    private T[] elem;
    private int size;
    private int capacity;

    public BinHeap() {
        this(1000);
    }

    public BinHeap(int capacity) {
        if (capacity < 10) {
            capacity = 10;
        }
        this.capacity = capacity;
        this.elem = new Object[capacity + 1];
        this.prio = new double[capacity + 1];
        this.size = 0;
        this.prio[0] = Double.NEGATIVE_INFINITY;
    }

    public int size() {
        return this.size;
    }

    public boolean empty() {
        return this.size <= 0;
    }

    public double peek_min_key() {
        if (this.size > 0) {
            return this.prio[1];
        }
        throw new IllegalStateException("An empty queue does not have a minimum key.");
    }

    public T peek_min() {
        if (this.size > 0) {
            return this.elem[1];
        }
        return null;
    }

    public void rekey(T e, double p) {
        int i = 0;
        for (T t : this.elem) {
            if (t == e) break;
            ++i;
        }
        if (i > this.size) {
            return;
        }
        if (p > this.prio[i]) {
            while (i * 2 <= this.size) {
                int child = i * 2;
                if (child != this.size && this.prio[child + 1] < this.prio[child]) {
                    ++child;
                }
                if (p > this.prio[child]) {
                    this.elem[i] = this.elem[child];
                    this.prio[i] = this.prio[child];
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            while (this.prio[i / 2] > p) {
                this.elem[i] = this.elem[i / 2];
                this.prio[i] = this.prio[i / 2];
                i /= 2;
            }
        }
        this.elem[i] = e;
        this.prio[i] = p;
    }

    public void dump() {
        for (int i = 0; i <= this.capacity; ++i) {
            String topMarker = i > this.size ? "(UNUSED)" : "";
            System.out.printf("%d\t%f\t%s\t%s\n", i, this.prio[i], this.elem[i], topMarker);
        }
        System.out.printf("-----------------------\n", new Object[0]);
    }

    public void reset() {
        this.size = 0;
    }

    public void insert(T e, double p) {
        ++this.size;
        if (this.size > this.capacity) {
            this.resize((int)((double)this.capacity * 2.0));
        }
        int i = this.size;
        while (this.prio[i / 2] > p) {
            this.elem[i] = this.elem[i / 2];
            this.prio[i] = this.prio[i / 2];
            i /= 2;
        }
        this.elem[i] = e;
        this.prio[i] = p;
    }

    public T extract_min() {
        T minElem = this.elem[1];
        T lastElem = this.elem[this.size];
        double lastPrio = this.prio[this.size];
        if (this.size <= 0) {
            return null;
        }
        --this.size;
        int i = 1;
        while (i * 2 <= this.size) {
            int child = i * 2;
            if (child != this.size && this.prio[child + 1] < this.prio[child]) {
                ++child;
            }
            if (!(lastPrio > this.prio[child])) break;
            this.elem[i] = this.elem[child];
            this.prio[i] = this.prio[child];
            i = child;
        }
        this.elem[i] = lastElem;
        this.prio[i] = lastPrio;
        return minElem;
    }

    public void resize(int capacity) {
        if (capacity < this.size) {
            throw new IllegalStateException("BinHeap contains too many elements to fit in new capacity.");
        }
        this.capacity = capacity;
        this.prio = Arrays.copyOf(this.prio, capacity + 1);
        this.elem = Arrays.copyOf(this.elem, capacity + 1);
    }

    public int getCapacity() {
        return this.capacity;
    }
}

