/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WebMercatorTile {
    public static String getTileNumber(double lat, double lon, int zoom) {
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return zoom + "/" + xtile + "/" + ytile;
    }

    public static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static Envelope2D tile2Envelope(int x, int y, int zoom) {
        double maxLat = WebMercatorTile.tile2lat(y, zoom);
        double minLat = WebMercatorTile.tile2lat(y + 1, zoom);
        double minLon = WebMercatorTile.tile2lon(x, zoom);
        double maxLon = WebMercatorTile.tile2lon(x + 1, zoom);
        return new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, minLon, minLat, maxLon - minLon, maxLat - minLat);
    }
}

