/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Supplier;

public class RepeatingTimePeriod
implements Serializable {
    private final ZoneId timeZone;
    private int[][] monday;
    private int[][] tuesday;
    private int[][] wednesday;
    private int[][] thursday;
    private int[][] friday;
    private int[][] saturday;
    private int[][] sunday;

    public RepeatingTimePeriod(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public static RepeatingTimePeriod parseFromOsmTurnRestriction(String day_on, String day_off, String hour_on, String hour_off, Supplier<ZoneId> timeZoneSupplier) {
        String[] parsedOff;
        ZoneId timeZone = timeZoneSupplier.get();
        if (timeZone == null) {
            return null;
        }
        String[] parsedOn = hour_on.split(";");
        if (parsedOn.length != (parsedOff = hour_off.split(";")).length) {
            return null;
        }
        int[][] onOff = new int[parsedOn.length][];
        for (int i = 0; i < parsedOn.length; ++i) {
            onOff[i] = new int[]{RepeatingTimePeriod.parseHour(parsedOn[i]), RepeatingTimePeriod.parseHour(parsedOff[i])};
        }
        boolean active = false;
        RepeatingTimePeriod ret = new RepeatingTimePeriod(timeZone);
        for (String today : new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"}) {
            if (today.startsWith(day_on.toLowerCase())) {
                active = true;
            }
            if (active) {
                switch (today) {
                    case "monday": {
                        ret.monday = onOff;
                        break;
                    }
                    case "tuesday": {
                        ret.tuesday = onOff;
                        break;
                    }
                    case "wednesday": {
                        ret.wednesday = onOff;
                        break;
                    }
                    case "thursday": {
                        ret.thursday = onOff;
                        break;
                    }
                    case "friday": {
                        ret.friday = onOff;
                        break;
                    }
                    case "saturday": {
                        ret.saturday = onOff;
                        break;
                    }
                    case "sunday": {
                        ret.sunday = onOff;
                    }
                }
            }
            if (!today.startsWith(day_off.toLowerCase())) continue;
            active = false;
        }
        return ret;
    }

    public boolean active(long time) {
        int[][] times;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(time), this.timeZone);
        DayOfWeek dayOfWeek = zonedDateTime.getDayOfWeek();
        switch (dayOfWeek) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MONDAY: {
                int[][] nArray = this.monday;
                break;
            }
            case TUESDAY: {
                int[][] nArray = this.tuesday;
                break;
            }
            case WEDNESDAY: {
                int[][] nArray = this.wednesday;
                break;
            }
            case THURSDAY: {
                int[][] nArray = this.thursday;
                break;
            }
            case FRIDAY: {
                int[][] nArray = this.friday;
                break;
            }
            case SATURDAY: {
                int[][] nArray = this.saturday;
                break;
            }
            case SUNDAY: {
                int[][] nArray = times = this.sunday;
            }
        }
        if (times == null) {
            return false;
        }
        int timeOfDay = zonedDateTime.toLocalTime().toSecondOfDay() - 43200;
        for (int[] range : times) {
            if (timeOfDay < range[0] || timeOfDay > range[1]) continue;
            return true;
        }
        return false;
    }

    private static int parseHour(String hour) {
        String[] parsed = hour.split(":");
        int ret = Integer.parseInt(parsed[0]) * 3600;
        if (parsed.length >= 2) {
            ret += Integer.parseInt(parsed[1]) * 60;
        }
        return ret -= 43200;
    }
}

