/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.opentripplanner.api.model.ApiRouterInfo;
import org.opentripplanner.api.model.ApiRouterList;
import org.opentripplanner.routing.error.GraphNotFoundException;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers")
@PermitAll
public class Routers {
    private final OtpServerRequestContext serverContext;

    public Routers(@Context OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
    }

    @GET
    @Path(value="{ignoreRouterId}")
    @Produces(value={"application/json"})
    public ApiRouterInfo getGraphId(@PathParam(value="ignoreRouterId") String ignore) {
        return this.getRouterInfo();
    }

    @GET
    @Produces(value={"application/json"})
    public ApiRouterList getRouterIds() {
        ApiRouterList routerList = new ApiRouterList();
        routerList.routerInfo.add(this.getRouterInfo());
        return routerList;
    }

    private ApiRouterInfo getRouterInfo() {
        try {
            OtpServerRequestContext serverContext = this.serverContext;
            return new ApiRouterInfo("default", serverContext.graph(), serverContext.transitService());
        }
        catch (GraphNotFoundException e) {
            return null;
        }
    }
}

