/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.model;

import java.util.Date;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.ModeMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.TravelOption;
import org.opentripplanner.util.TravelOptionsMaker;
import org.opentripplanner.util.WorldEnvelope;

public class ApiRouterInfo {
    private final WorldEnvelope envelope;
    public final boolean hasBikePark;
    public final boolean hasCarPark;
    public final boolean hasVehicleParking;
    public String routerId;
    public Geometry polygon;
    public Date buildTime;
    public long transitServiceStarts;
    public long transitServiceEnds;
    public List<String> transitModes;
    public double centerLatitude;
    public double centerLongitude;
    public boolean hasParkRide;
    public boolean hasBikeSharing;
    public List<TravelOption> travelOptions;

    public ApiRouterInfo(String routerId, Graph graph, TransitService transitService) {
        VehicleRentalStationService vehicleRentalService = graph.getVehicleRentalStationService();
        VehicleParkingService vehicleParkingService = graph.getVehicleParkingService();
        this.routerId = routerId;
        this.polygon = graph.getConvexHull();
        this.buildTime = Date.from(graph.buildTime);
        this.transitServiceStarts = transitService.getTransitServiceStarts().toEpochSecond();
        this.transitServiceEnds = transitService.getTransitServiceEnds().toEpochSecond();
        this.transitModes = ModeMapper.mapToApi(transitService.getTransitModes());
        this.envelope = graph.getEnvelope();
        this.hasParkRide = graph.hasParkRide;
        this.hasBikeSharing = this.mapHasBikeSharing(vehicleRentalService);
        this.hasBikePark = this.mapHasBikePark(vehicleParkingService);
        this.hasCarPark = this.mapHasCarPark(vehicleParkingService);
        this.hasVehicleParking = this.mapHasVehicleParking(vehicleParkingService);
        this.travelOptions = TravelOptionsMaker.makeOptions(graph, transitService);
        transitService.getCenter().ifPresentOrElse(this::setCenter, this::calculateCenter);
    }

    public boolean mapHasBikeSharing(VehicleRentalStationService service) {
        if (service == null) {
            return false;
        }
        return service.getVehicleRentalPlaces().size() > 1;
    }

    public boolean mapHasBikePark(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getBikeParks().findAny().isPresent();
    }

    public boolean mapHasCarPark(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getCarParks().findAny().isPresent();
    }

    public boolean mapHasVehicleParking(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getVehicleParkings().findAny().isPresent();
    }

    public void setCenter(Coordinate center) {
        this.centerLongitude = center.x;
        this.centerLatitude = center.y;
    }

    public void calculateCenter() {
        this.centerLatitude = (this.getUpperRightLatitude() + this.getLowerLeftLatitude()) / 2.0;
        this.centerLongitude = (this.getUpperRightLongitude() + this.getLowerLeftLongitude()) / 2.0;
    }

    public double getLowerLeftLatitude() {
        return this.envelope.getLowerLeftLatitude();
    }

    public double getLowerLeftLongitude() {
        return this.envelope.getLowerLeftLongitude();
    }

    public double getUpperRightLatitude() {
        return this.envelope.getUpperRightLatitude();
    }

    public double getUpperRightLongitude() {
        return this.envelope.getUpperRightLongitude();
    }
}

