/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.util.Date;
import java.util.Locale;
import org.opentripplanner.api.mapping.ItineraryMapper;
import org.opentripplanner.api.mapping.PlaceMapper;
import org.opentripplanner.api.model.ApiTripPlan;
import org.opentripplanner.model.plan.TripPlan;

public class TripPlanMapper {
    private final ItineraryMapper itineraryMapper;
    private final PlaceMapper placeMapper;

    public TripPlanMapper(Locale locale, boolean addIntermediateStops) {
        this.itineraryMapper = new ItineraryMapper(locale, addIntermediateStops);
        this.placeMapper = new PlaceMapper(locale);
    }

    public ApiTripPlan mapTripPlan(TripPlan domain) {
        if (domain == null) {
            return null;
        }
        ApiTripPlan api = new ApiTripPlan();
        api.date = Date.from(domain.date);
        api.from = this.placeMapper.mapPlace(domain.from, null, null, null, null);
        api.to = this.placeMapper.mapPlace(domain.to, null, null, null, null);
        api.itineraries = this.itineraryMapper.mapItineraries(domain.itineraries);
        return api;
    }
}

