/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.dao;

import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexingOperationListener;

public class Ip2GeoCachedDao
implements IndexingOperationListener {
    @Generated
    private static final Logger log = LogManager.getLogger(Ip2GeoCachedDao.class);
    private final DatasourceDao datasourceDao;
    private final GeoIpDataDao geoIpDataDao;
    private final GeoDataCache geoDataCache;
    private Map<String, DatasourceMetadata> metadata;

    public Ip2GeoCachedDao(ClusterService clusterService, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao) {
        this.datasourceDao = datasourceDao;
        this.geoIpDataDao = geoIpDataDao;
        this.geoDataCache = new GeoDataCache((Long)clusterService.getClusterSettings().get(Ip2GeoSettings.CACHE_SIZE));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(Ip2GeoSettings.CACHE_SIZE, setting -> this.geoDataCache.updateMaxSize((long)setting));
    }

    public String getIndexName(String datasourceName) {
        return this.getMetadata().getOrDefault(datasourceName, DatasourceMetadata.EMPTY_METADATA).getIndexName();
    }

    public boolean isExpired(String datasourceName) {
        return this.getMetadata().getOrDefault(datasourceName, DatasourceMetadata.EMPTY_METADATA).getExpirationDate().isBefore(Instant.now());
    }

    public boolean has(String datasourceName) {
        return this.getMetadata().containsKey(datasourceName);
    }

    public DatasourceState getState(String datasourceName) {
        return this.getMetadata().getOrDefault(datasourceName, DatasourceMetadata.EMPTY_METADATA).getState();
    }

    public Map<String, Object> getGeoData(String indexName, String ip) {
        try {
            return this.geoDataCache.putIfAbsent(indexName, ip, addr -> this.geoIpDataDao.getGeoIpData(indexName, ip));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DatasourceMetadata> getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        Ip2GeoCachedDao ip2GeoCachedDao = this;
        synchronized (ip2GeoCachedDao) {
            if (this.metadata != null) {
                return this.metadata;
            }
            ConcurrentHashMap<String, DatasourceMetadata> tempData = new ConcurrentHashMap<String, DatasourceMetadata>();
            try {
                this.datasourceDao.getAllDatasources().stream().forEach(datasource -> tempData.put(datasource.getName(), new DatasourceMetadata((Datasource)datasource)));
            }
            catch (IndexNotFoundException e) {
                log.debug("Datasource has never been created");
            }
            this.metadata = tempData;
            return this.metadata;
        }
    }

    private void put(Datasource datasource) {
        DatasourceMetadata metadata = new DatasourceMetadata(datasource);
        this.getMetadata().put(datasource.getName(), metadata);
    }

    private void remove(String datasourceName) {
        this.getMetadata().remove(datasourceName);
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        if (Engine.Result.Type.FAILURE.equals((Object)result.getResultType())) {
            return;
        }
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, index.source().utf8ToString());
            parser.nextToken();
            Datasource datasource = (Datasource)Datasource.PARSER.parse(parser, null);
            this.put(datasource);
        }
        catch (IOException e) {
            log.error("IOException occurred updating datasource metadata for datasource {} ", (Object)index.id(), (Object)e);
        }
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (result.getResultType().equals((Object)Engine.Result.Type.FAILURE)) {
            return;
        }
        this.remove(delete.id());
    }

    @VisibleForTesting
    protected static class GeoDataCache {
        private Cache<CacheKey, Map<String, Object>> cache;

        public GeoDataCache(long maxSize) {
            if (maxSize < 0L) {
                throw new IllegalArgumentException("ip2geo max cache size must be 0 or greater");
            }
            this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
        }

        public Map<String, Object> putIfAbsent(String indexName, String ip, Function<String, Map<String, Object>> retrieveFunction) throws ExecutionException {
            CacheKey cacheKey = new CacheKey(indexName, ip);
            return (Map)this.cache.computeIfAbsent((Object)cacheKey, key -> (Map)retrieveFunction.apply(key.ip));
        }

        public Map<String, Object> get(String indexName, String ip) {
            return (Map)this.cache.get((Object)new CacheKey(indexName, ip));
        }

        public void updateMaxSize(long maxSize) {
            if (maxSize < 0L) {
                throw new IllegalArgumentException("ip2geo max cache size must be 0 or greater");
            }
            Cache temp = CacheBuilder.builder().setMaximumWeight(maxSize).build();
            int count = 0;
            Iterator it = this.cache.keys().iterator();
            while (it.hasNext() && (long)count < maxSize) {
                CacheKey key = (CacheKey)it.next();
                temp.put((Object)key, (Object)((Map)this.cache.get((Object)key)));
                ++count;
            }
            this.cache = temp;
        }

        private static class CacheKey {
            private final String indexName;
            private final String ip;

            @Generated
            public CacheKey(String indexName, String ip) {
                this.indexName = indexName;
                this.ip = ip;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$indexName = this.indexName;
                String other$indexName = other.indexName;
                if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
                    return false;
                }
                String this$ip = this.ip;
                String other$ip = other.ip;
                return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CacheKey;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $indexName = this.indexName;
                result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
                String $ip = this.ip;
                result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
                return result;
            }
        }
    }

    private static class DatasourceMetadata {
        private static DatasourceMetadata EMPTY_METADATA = new DatasourceMetadata();
        private String indexName;
        private Instant expirationDate;
        private DatasourceState state;

        private DatasourceMetadata() {
            this.expirationDate = Instant.MIN;
        }

        public DatasourceMetadata(Datasource datasource) {
            this.indexName = datasource.currentIndexName();
            this.expirationDate = datasource.expirationDay();
            this.state = datasource.getState();
        }

        @Generated
        public String getIndexName() {
            return this.indexName;
        }

        @Generated
        public Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Generated
        public DatasourceState getState() {
            return this.state;
        }
    }
}

