/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.xcontent.filtering;

import java.util.ArrayList;
import java.util.Set;
import org.opensearch.common.Glob;

public class FilterPath {
    static final FilterPath EMPTY = new FilterPath();
    private final String filter;
    private final String segment;
    private final FilterPath next;
    private final boolean simpleWildcard;
    private final boolean doubleWildcard;

    protected FilterPath(String filter, String segment, FilterPath next) {
        this.filter = filter;
        this.segment = segment;
        this.next = next;
        this.simpleWildcard = segment != null && segment.length() == 1 && segment.charAt(0) == '*';
        this.doubleWildcard = segment != null && segment.length() == 2 && segment.charAt(0) == '*' && segment.charAt(1) == '*';
    }

    private FilterPath() {
        this("<empty>", "", null);
    }

    public FilterPath matchProperty(String name) {
        if (this.next != null && (this.simpleWildcard || this.doubleWildcard || Glob.globMatch((String)this.segment, (String)name))) {
            return this.next;
        }
        return null;
    }

    public boolean matches() {
        return this.next == null;
    }

    boolean isDoubleWildcard() {
        return this.doubleWildcard;
    }

    boolean isSimpleWildcard() {
        return this.simpleWildcard;
    }

    String getSegment() {
        return this.segment;
    }

    FilterPath getNext() {
        return this.next;
    }

    public static FilterPath[] compile(Set<String> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList<FilterPath> paths = new ArrayList<FilterPath>();
        for (String filter : filters) {
            if (filter == null || filter.isEmpty() || (filter = filter.trim()).length() <= 0) continue;
            paths.add(FilterPath.parse(filter));
        }
        return paths.toArray(new FilterPath[paths.size()]);
    }

    private static FilterPath parse(String filter) {
        String[] segments = filter.split("(?<!\\\\)\\.");
        FilterPath next = EMPTY;
        for (int i = segments.length - 1; i >= 0; --i) {
            String segment = segments[i].replaceAll("\\\\.", ".");
            next = new FilterPath(filter, segment, next);
        }
        return next;
    }

    public String toString() {
        return "FilterPath [filter=" + this.filter + ", segment=" + this.segment + "]";
    }
}

