/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.test.plugins.junit;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.pipeline.parser.ParseException;
import org.opensearch.dataprepper.pipeline.parser.PipelinesDataflowModelParser;
import org.opensearch.dataprepper.test.plugins.DataPrepperPluginTest;
import org.opensearch.dataprepper.test.plugins.PluginConfigurationFile;
import org.opensearch.dataprepper.test.plugins.junit.TestApplicationContextProvider;

class PluginInstanceParameterResolver
implements ParameterResolver {
    PluginInstanceParameterResolver() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class testClass = extensionContext.getRequiredTestClass();
        DataPrepperPluginTest annotation = testClass.getAnnotation(DataPrepperPluginTest.class);
        if (annotation == null) {
            return false;
        }
        return Objects.equals(annotation.pluginType(), parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class testClass = extensionContext.getRequiredTestClass();
        DataPrepperPluginTest annotation = testClass.getAnnotation(DataPrepperPluginTest.class);
        if (annotation == null) {
            throw new ParameterResolutionException("Missing @DataPrepperPluginTest annotation on class: " + testClass.getName());
        }
        PluginConfigurationFile configurationFileAnnotation = (PluginConfigurationFile)parameterContext.findAnnotation(PluginConfigurationFile.class).orElseThrow(() -> new ParameterResolutionException("Parameter resolver used without @PluginConfigurationFile."));
        String configurationFile = configurationFileAnnotation.value();
        PluginSetting pluginSetting = this.generatePluginSetting(testClass, configurationFile);
        PluginFactory pluginFactory = this.getOrCreatePluginFactory(extensionContext);
        Class<?> pluginType = annotation.pluginType();
        return pluginFactory.loadPlugin(pluginType, pluginSetting, new Object[0]);
    }

    private PluginSetting generatePluginSetting(Class<?> testClass, String configurationFile) {
        PipelinesDataFlowModel pipelinesDataFlowModel = PluginInstanceParameterResolver.readPipelinesDataFlowModel(testClass, configurationFile);
        String pipelineName = PluginInstanceParameterResolver.readSinglePipeline(pipelinesDataFlowModel, configurationFile);
        PipelineModel pipelineModel = (PipelineModel)pipelinesDataFlowModel.getPipelines().get(pipelineName);
        PluginModel pluginModel = PluginInstanceParameterResolver.loadPluginModel(pipelineModel, configurationFile);
        Map settingsMap = Optional.ofNullable(pluginModel.getPluginSettings()).orElseGet(HashMap::new);
        PluginSetting pluginSetting = new PluginSetting(pluginModel.getPluginName(), settingsMap);
        pluginSetting.setPipelineName(pipelineName);
        return pluginSetting;
    }

    private static PluginModel loadPluginModel(PipelineModel pipelineModel, String configurationFile) {
        if (pipelineModel.getProcessors() == null || pipelineModel.getProcessors().size() != 1) {
            throw new ParameterResolutionException("Test configurations must define plugins in the processor section. " + configurationFile);
        }
        return (PluginModel)pipelineModel.getProcessors().stream().findFirst().orElseThrow(() -> new ParameterResolutionException("Test configurations must define plugins in the processor section. " + configurationFile));
    }

    private static String readSinglePipeline(PipelinesDataFlowModel pipelinesDataFlowModel, String configurationFile) {
        if (pipelinesDataFlowModel.getPipelines().size() != 1) {
            throw new ParameterResolutionException("Test configurations must have exactly one pipeline. " + configurationFile);
        }
        return (String)pipelinesDataFlowModel.getPipelines().keySet().stream().findFirst().orElseThrow(() -> new ParameterResolutionException("Test configurations must have exactly one pipeline. " + configurationFile));
    }

    private static PipelinesDataFlowModel readPipelinesDataFlowModel(Class<?> testClass, String configurationFile) {
        PipelinesDataFlowModel pipelinesDataFlowModel;
        try (InputStream resourceStream = testClass.getResourceAsStream(configurationFile);){
            if (resourceStream == null) {
                throw new ParameterResolutionException("Unable to find a configuration file " + configurationFile + " in the " + testClass.getPackageName() + " package.");
            }
            PipelinesDataflowModelParser pipelinesDataflowModelParser = new PipelinesDataflowModelParser(() -> List.of(resourceStream));
            try {
                pipelinesDataFlowModel = pipelinesDataflowModelParser.parseConfiguration();
            }
            catch (ParseException ex) {
                throw new ParameterResolutionException("Failed to parse configuration file " + configurationFile + ".", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return pipelinesDataFlowModel;
    }

    private PluginFactory getOrCreatePluginFactory(ExtensionContext extensionContext) {
        return (PluginFactory)TestApplicationContextProvider.get(extensionContext).getBean(PluginFactory.class);
    }
}

