/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.test.plugins.junit;

import java.util.Map;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.opensearch.dataprepper.event.TestEventFactory;
import org.opensearch.dataprepper.event.TestEventKeyFactory;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

class EventParameterResolver
implements ParameterResolver {
    private static final Map<Class<?>, Supplier<?>> SUPPORTED_CLASSES = Map.of(EventFactory.class, TestEventFactory::getTestEventFactory, EventKeyFactory.class, TestEventKeyFactory::getTestEventFactory);

    EventParameterResolver() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return SUPPORTED_CLASSES.containsKey(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return SUPPORTED_CLASSES.get(type).get();
    }
}

