/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.useragent;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.useragent.CaffeineCachingParser;
import org.opensearch.dataprepper.plugins.processor.useragent.UserAgentProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ua_parser.Client;
import ua_parser.Parser;

@DataPrepperPlugin(name="user_agent", pluginType=Processor.class, pluginConfigurationType=UserAgentProcessorConfig.class)
public class UserAgentProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentProcessor.class);
    private final UserAgentProcessorConfig config;
    private final Parser userAgentParser;
    private final EventKey sourceKey;
    private final EventKey targetKey;

    @DataPrepperPluginConstructor
    public UserAgentProcessor(UserAgentProcessorConfig config, EventKeyFactory eventKeyFactory, PluginMetrics pluginMetrics) {
        super(pluginMetrics);
        this.config = config;
        this.userAgentParser = new CaffeineCachingParser(config.getCacheSize());
        this.sourceKey = config.getSource();
        this.targetKey = eventKeyFactory.createEventKey(config.getTarget(), new EventKeyFactory.EventAction[]{EventKeyFactory.EventAction.PUT});
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            try {
                String userAgentStr = (String)event.get(this.sourceKey, String.class);
                Objects.requireNonNull(userAgentStr);
                Client clientInfo = this.userAgentParser.parse(userAgentStr);
                Map<String, Object> parsedUserAgent = this.getParsedUserAgent(clientInfo);
                if (!this.config.getExcludeOriginal()) {
                    parsedUserAgent.put("original", userAgentStr);
                }
                event.put(this.targetKey, parsedUserAgent);
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.EVENT, "An exception occurred when parsing user agent data from event [{}] with source key [{}]", new Object[]{event, this.sourceKey, e});
                List<String> tagsOnParseFailure = this.config.getTagsOnParseFailure();
                if (!Objects.nonNull(tagsOnParseFailure) || tagsOnParseFailure.size() <= 0) continue;
                event.getMetadata().addTags(tagsOnParseFailure);
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private Map<String, Object> getParsedUserAgent(Client clientInfo) {
        String version = this.getFullVersion(clientInfo.userAgent.major, clientInfo.userAgent.minor, clientInfo.userAgent.patch);
        HashMap<String, Object> parsedUserAgent = new HashMap<String, Object>();
        parsedUserAgent.put("name", clientInfo.userAgent.family);
        parsedUserAgent.put("version", version);
        parsedUserAgent.put("os", this.getParsedOS(clientInfo));
        parsedUserAgent.put("device", this.getParsedDevice(clientInfo));
        return parsedUserAgent;
    }

    private String getFullVersion(String major, String minor, String patch) {
        if (Objects.isNull(major)) {
            return "";
        }
        if (Objects.isNull(minor)) {
            return major;
        }
        if (Objects.isNull(patch)) {
            return major + "." + minor;
        }
        return major + "." + minor + "." + patch;
    }

    private Map<String, String> getParsedOS(Client clientInfo) {
        String version = this.getFullVersion(clientInfo.os.major, clientInfo.os.minor, clientInfo.os.patch);
        return Map.of("name", clientInfo.os.family, "version", version, "full", version.isEmpty() ? clientInfo.os.family : clientInfo.os.family + " " + version);
    }

    private Map<String, String> getParsedDevice(Client clientInfo) {
        return Map.of("name", clientInfo.device.family);
    }
}

