/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.useragent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>user_agent</code> processor parses any user agent (UA) string in an event and then adds the parsed results to the event.")
public class UserAgentProcessorConfig {
    private static final int DEFAULT_CACHE_SIZE = 1000;
    @NotEmpty
    @NotNull
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The field in the event that will be parsed.")
    @EventKeyConfiguration(value={EventKeyFactory.EventAction.GET})
    private EventKey source;
    @NotNull
    @JsonProperty(value="target", defaultValue="user_agent")
    @JsonPropertyDescription(value="The field to which the parsed event will write. Default is <code>user_agent</code>.")
    private String target = "user_agent";
    @NotNull
    @JsonProperty(value="exclude_original")
    @JsonPropertyDescription(value="Determines whether to exclude the original UA string from the parsing result. Defaults to <code>false</code>.")
    private boolean excludeOriginal = false;
    @JsonProperty(value="cache_size", defaultValue="1000")
    @JsonPropertyDescription(value="The cache size of the parser in megabytes. Defaults to <code>1000</code>.")
    private int cacheSize = 1000;
    @JsonProperty(value="tags_on_parse_failure")
    @JsonPropertyDescription(value="The tag to add to an event if the <code>user_agent</code> processor fails to parse the UA string.")
    private List<String> tagsOnParseFailure;

    public EventKey getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean getExcludeOriginal() {
        return this.excludeOriginal;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public List<String> getTagsOnParseFailure() {
        return this.tagsOnParseFailure;
    }
}

