/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JsonExtractor {
    private static final String DELIMITER = "/";

    public String getRootField(String fullPath) {
        List<String> fieldsInPath = this.getFieldsInPath(fullPath);
        return fieldsInPath.isEmpty() ? "" : fieldsInPath.get(0);
    }

    public String getLeafField(String fullPath) {
        String strippedPath = this.getStrippedPath(fullPath);
        String[] fields = strippedPath.split(DELIMITER);
        return fields.length == 0 ? "" : fields[fields.length - 1].strip();
    }

    public String getParentPath(String fullPath) {
        String strippedPath = this.getStrippedPath(fullPath);
        String[] fields = strippedPath.split(DELIMITER);
        if (fields.length <= 1) {
            return "";
        }
        return Arrays.stream(fields, 0, fields.length - 1).collect(Collectors.joining(DELIMITER));
    }

    public List<Object> getObjectFromPath(String path, Object rootObject) {
        List<String> fieldsInPath = this.getFieldsInPath(path);
        if (fieldsInPath.isEmpty()) {
            return List.of(rootObject);
        }
        return this.getLeafObjects(fieldsInPath, 0, rootObject);
    }

    private List<String> getFieldsInPath(String path) {
        String strippedPath = this.getStrippedPath(path);
        if (strippedPath.isEmpty()) {
            return List.of();
        }
        return new ArrayList<String>(Arrays.asList(strippedPath.split(DELIMITER)));
    }

    private List<Object> getLeafObjects(List<String> fieldsInPath, int level, Object rootObject) {
        if (Objects.isNull(rootObject)) {
            return List.of();
        }
        if (rootObject instanceof List) {
            return ((List)rootObject).stream().flatMap(arrayObject -> this.getLeafObjects(fieldsInPath, level, arrayObject).stream()).collect(Collectors.toList());
        }
        if (rootObject instanceof Map) {
            if (level >= fieldsInPath.size()) {
                return List.of(rootObject);
            }
            String field = fieldsInPath.get(level);
            Object outObj = ((Map)rootObject).get(field);
            return this.getLeafObjects(fieldsInPath, level + 1, outObj);
        }
        return List.of();
    }

    private String getStrippedPath(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path cannot be null");
        return path.strip();
    }
}

