/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.processor.translate.JsonExtractor;
import org.opensearch.dataprepper.plugins.processor.translate.TargetsParameterConfig;

public class MappingsParameterConfig {
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The source field to translate. Can be a string or a list of strings.")
    @NotNull
    private Object source;
    @JsonProperty(value="targets")
    @JsonPropertyDescription(value="A list of target field configurations, such as the target field key or translation maps.")
    @Valid
    @NotNull
    private List<TargetsParameterConfig> targetsParameterConfigs = new ArrayList<TargetsParameterConfig>();

    public Object getSource() {
        return this.source;
    }

    public List<TargetsParameterConfig> getTargetsParameterConfigs() {
        return this.targetsParameterConfigs;
    }

    @AssertTrue(message="source option not configured")
    public @AssertTrue(message="source option not configured") boolean isSourcePresent() {
        return Objects.nonNull(this.source);
    }

    @AssertTrue(message="targets option not configured")
    public @AssertTrue(message="targets option not configured") boolean isTargetsPresent() {
        return Objects.nonNull(this.targetsParameterConfigs) && !this.targetsParameterConfigs.isEmpty();
    }

    @AssertTrue(message="The \"source\" field should either be a string or a list of strings sharing the same parent path.")
    public @AssertTrue(message="The \"source\" field should either be a string or a list of strings sharing the same parent path.") boolean isSourceFieldValid() {
        if (Objects.isNull(this.source)) {
            return true;
        }
        if (this.source instanceof String) {
            return true;
        }
        if (this.source instanceof List) {
            List sourceList = (List)this.source;
            if (sourceList.isEmpty()) {
                return false;
            }
            return sourceList.stream().allMatch(sourceItem -> sourceItem instanceof String) && this.commonRootPath(sourceList);
        }
        return false;
    }

    public boolean commonRootPath(List<?> sourceList) {
        List<?> sources = sourceList;
        JsonExtractor jsonExtractor = new JsonExtractor();
        String firstSource = (String)sources.get(0);
        String parentPath = jsonExtractor.getParentPath(firstSource);
        for (String source : sources) {
            if (jsonExtractor.getParentPath(source).equals(parentPath)) continue;
            return false;
        }
        return true;
    }

    public void parseMappings() {
        if (Objects.isNull(this.targetsParameterConfigs)) {
            return;
        }
        for (TargetsParameterConfig targetsParameterConfig : this.targetsParameterConfigs) {
            targetsParameterConfig.parseMappings();
        }
    }

    public void setTargetsParameterConfigs(List<TargetsParameterConfig> targetsParameterConfigs) {
        this.targetsParameterConfigs = targetsParameterConfigs;
    }
}

