/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.processor.translate.FileMappingsRef;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsParameterConfig;
import org.opensearch.dataprepper.plugins.processor.translate.S3ObjectConfig;
import org.opensearch.dataprepper.plugins.processor.translate.TargetsParameterConfig;
import org.opensearch.dataprepper.plugins.processor.translate.TranslateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class MappingsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MappingsHandler.class);

    public List<MappingsParameterConfig> getS3FileMappings(S3ObjectConfig awsConfig, String key) {
        List<MappingsParameterConfig> s3FileMappings;
        if (!this.isAwsConfigValid(awsConfig) || key == null) {
            return null;
        }
        String regionString = awsConfig.getRegion();
        Region region = Region.of((String)regionString);
        String roleARN = awsConfig.getStsRoleArn();
        String bucketName = awsConfig.getBucket();
        String roleSessionName = "translate-session";
        try {
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).region(region)).build();
            AssumeRoleResponse response = stsClient.assumeRole((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleARN).roleSessionName(roleSessionName).build());
            Credentials temporaryCredentials = response.credentials();
            AwsSessionCredentials sessionCredentials = AwsSessionCredentials.create((String)temporaryCredentials.accessKeyId(), (String)temporaryCredentials.secretAccessKey(), (String)temporaryCredentials.sessionToken());
            S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)sessionCredentials))).region(region)).build();
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
            try {
                int bytesRead;
                ResponseInputStream responseInputStream = s3Client.getObject(getObjectRequest);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = responseInputStream.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                }
                responseInputStream.close();
                byte[] fileData = byteArrayOutputStream.toByteArray();
                s3FileMappings = this.getMappingsFromByteArray(fileData);
                byteArrayOutputStream.close();
            }
            catch (IOException | AwsServiceException e) {
                LOG.error("Error while retrieving mappings from S3 Object", e);
                return null;
            }
        }
        catch (AwsServiceException e) {
            LOG.error("Error while retrieving mappings from S3 Object", (Throwable)e);
            return null;
        }
        return s3FileMappings;
    }

    public List<MappingsParameterConfig> getMappingsFromFilePath(String fileName) {
        try {
            Path filePath = Paths.get(fileName, new String[0]);
            byte[] fileData = Files.readAllBytes(filePath);
            return this.getMappingsFromByteArray(fileData);
        }
        catch (IOException ex) {
            LOG.error("Unable to parse the mappings from file", (Throwable)ex);
            return null;
        }
    }

    private List<MappingsParameterConfig> getMappingsFromByteArray(byte[] file) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            FileMappingsRef fileParser = (FileMappingsRef)mapper.readValue(file, FileMappingsRef.class);
            return fileParser.getFileMappingConfigs();
        }
        catch (IOException ex) {
            LOG.error("Unable to parse the mappings from file", (Throwable)ex);
            return null;
        }
    }

    public List<MappingsParameterConfig> getCombinedMappings(List<MappingsParameterConfig> mappingConfigs, List<MappingsParameterConfig> fileMappingConfigs) {
        if (Objects.isNull(mappingConfigs) || mappingConfigs.isEmpty()) {
            return fileMappingConfigs;
        }
        if (fileMappingConfigs == null) {
            return mappingConfigs;
        }
        try {
            for (MappingsParameterConfig fileMappingConfig : fileMappingConfigs) {
                boolean isDuplicateSource = false;
                for (MappingsParameterConfig mappingConfig : mappingConfigs) {
                    if (!mappingConfig.getSource().equals(fileMappingConfig.getSource())) continue;
                    isDuplicateSource = true;
                    this.combineTargets(fileMappingConfig, mappingConfig);
                }
                if (isDuplicateSource) continue;
                mappingConfigs.add(fileMappingConfig);
            }
            return mappingConfigs;
        }
        catch (Exception ex) {
            Logger LOG = LoggerFactory.getLogger(TranslateProcessor.class);
            LOG.error("Error while combining mappings", (Throwable)ex);
            return null;
        }
    }

    private void combineTargets(MappingsParameterConfig filePathMapping, MappingsParameterConfig mappingConfig) {
        if (Objects.isNull(mappingConfig)) {
            return;
        }
        List<TargetsParameterConfig> fileTargetConfigs = filePathMapping.getTargetsParameterConfigs();
        List<TargetsParameterConfig> mappingsTargetConfigs = mappingConfig.getTargetsParameterConfigs();
        ArrayList<TargetsParameterConfig> combinedTargetConfigs = new ArrayList<TargetsParameterConfig>(mappingsTargetConfigs);
        for (TargetsParameterConfig fileTargetConfig : fileTargetConfigs) {
            if (this.isTargetPresent(fileTargetConfig, combinedTargetConfigs)) continue;
            combinedTargetConfigs.add(fileTargetConfig);
        }
        mappingConfig.setTargetsParameterConfigs(combinedTargetConfigs);
    }

    private boolean isTargetPresent(TargetsParameterConfig fileTargetConfig, List<TargetsParameterConfig> combinedTargetConfigs) {
        String fileTarget = fileTargetConfig.getTarget();
        return combinedTargetConfigs.stream().anyMatch(targetConfig -> fileTarget.equals(targetConfig.getTarget()));
    }

    private boolean isAwsConfigValid(S3ObjectConfig awsConfig) {
        return awsConfig != null && awsConfig.getBucket() != null && awsConfig.getRegion() != null && awsConfig.getStsRoleArn() != null;
    }
}

