/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.sqs;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.sqs.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.source.sqs.QueueConfig;

public class SqsSourceConfig {
    static final Duration DEFAULT_BUFFER_TIMEOUT = Duration.ofSeconds(10L);
    static final int DEFAULT_NUMBER_OF_RECORDS_TO_ACCUMULATE = 100;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationOptions awsAuthenticationOptions;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;
    @JsonProperty(value="buffer_timeout")
    private Duration bufferTimeout = DEFAULT_BUFFER_TIMEOUT;
    @JsonProperty(value="queues")
    @NotNull
    @Valid
    private List<QueueConfig> queues;

    public AwsAuthenticationOptions getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public boolean getAcknowledgements() {
        return this.acknowledgments;
    }

    public Duration getBufferTimeout() {
        return this.bufferTimeout;
    }

    public List<QueueConfig> getQueues() {
        return this.queues;
    }
}

