/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.stream.Stream;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3DataSelection;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanKeyPathOption;

public class S3ScanBucketOption {
    private static final String S3_PREFIX = "s3://";
    @JsonProperty(value="name")
    @NotEmpty
    @Size(min=3, max=500, message="bucket length should be at least 3 characters")
    private @NotEmpty @Size(min=3, max=500, message="bucket length should be at least 3 characters") String name;
    @JsonProperty(value="data_selection")
    private S3DataSelection dataSelection = S3DataSelection.DATA_AND_METADATA;
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @JsonProperty(value="start_time")
    private LocalDateTime startTime;
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    @JsonProperty(value="end_time")
    private LocalDateTime endTime;
    @JsonProperty(value="range")
    private Duration range;
    @JsonProperty(value="filter")
    private S3ScanKeyPathOption s3ScanFilter;

    @AssertTrue(message="At most two options from start_time, end_time and range can be specified at the same time")
    public @AssertTrue(message="At most two options from start_time, end_time and range can be specified at the same time") boolean hasValidTimeOptions() {
        return Stream.of(this.startTime, this.endTime, this.range).filter(x$0 -> Objects.nonNull(x$0)).count() < 3L;
    }

    @AssertFalse(message="bucket start_time or end_time cannot be used along with range")
    public @AssertFalse(message="bucket start_time or end_time cannot be used along with range") boolean hasValidTimeAndRangeOptions() {
        return (this.startTime != null || this.endTime != null) && this.range != null;
    }

    public S3DataSelection getDataSelection() {
        return this.dataSelection;
    }

    public String getName() {
        if (this.name.startsWith(S3_PREFIX)) {
            return this.name.substring(S3_PREFIX.length());
        }
        return this.name;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public Duration getRange() {
        return this.range;
    }

    public S3ScanKeyPathOption getS3ScanFilter() {
        return this.s3ScanFilter;
    }
}

