/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum S3SelectSerializationFormatOption {
    CSV("csv"),
    JSON("json"),
    PARQUET("parquet");

    private final String option;
    private static final Map<String, S3SelectSerializationFormatOption> OPTIONS_MAP;

    private S3SelectSerializationFormatOption(String option) {
        this.option = option;
    }

    @JsonCreator
    static S3SelectSerializationFormatOption fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(S3SelectSerializationFormatOption.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

