/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rss;

import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.RssReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.document.Document;
import org.opensearch.dataprepper.model.document.JacksonDocument;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RssReaderTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RssReaderTask.class);
    private final RssReader rssReader;
    private final String url;
    private final Buffer<Record<Document>> buffer;
    final Collection<Record<Document>> collection = new HashSet<Record<Document>>();

    public RssReaderTask(RssReader rssReader, String url, Buffer<Record<Document>> buffer) {
        this.rssReader = rssReader;
        this.url = url;
        this.buffer = buffer;
    }

    @Override
    public void run() {
        Stream itemStream;
        try {
            LOG.debug("Reading RSS Feed URL");
            itemStream = this.rssReader.read(this.url);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read the RSS Feed URL", e);
        }
        List items = itemStream.collect(Collectors.toList());
        if (items.isEmpty()) {
            return;
        }
        for (Item item : items) {
            LOG.debug("Converting Feed Item with ID:{} to an Event Document", (Object)item.getGuid());
            Record<Document> document = this.buildEventDocument(item);
            this.collection.add(document);
        }
        try {
            this.buffer.writeAll(this.collection, 500);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Record<Document> buildEventDocument(Item item) {
        JacksonDocument document = ((JacksonDocument.Builder)JacksonDocument.builder().withData((Object)item).getThis()).build();
        return new Record((Object)document);
    }
}

