/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.stream;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import java.io.IOException;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.rds.stream.BinlogEventListener;
import org.opensearch.dataprepper.plugins.source.rds.stream.ReplicationLogClient;
import org.opensearch.dataprepper.plugins.source.rds.utils.RdsSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogClientWrapper
implements ReplicationLogClient {
    private static final Logger LOG = LoggerFactory.getLogger(BinlogClientWrapper.class);
    static final String CONNECTION_REFUSED = "Connection refused";
    static final String FAILED_TO_DETERMINE_BINLOG_FILENAME = "Failed to determine binlog filename";
    static final String ACCESS_DENIED = "Access denied";
    private final BinaryLogClient binlogClient;
    private final RdsSourceAggregateMetrics rdsSourceAggregateMetrics;

    public BinlogClientWrapper(BinaryLogClient binlogClient, RdsSourceAggregateMetrics rdsSourceAggregateMetrics) {
        this.binlogClient = binlogClient;
        this.rdsSourceAggregateMetrics = rdsSourceAggregateMetrics;
    }

    @Override
    public void connect() throws IOException {
        try {
            this.rdsSourceAggregateMetrics.getStreamApiInvocations().increment();
            this.binlogClient.connect();
        }
        catch (Exception e) {
            LOG.error("Failed to connect to replication stream due to {}", (Object)e.getMessage());
            this.categorizeError(e);
            throw e;
        }
    }

    @Override
    public void disconnect() throws IOException {
        List eventListenerList = this.binlogClient.getEventListeners();
        if (!eventListenerList.isEmpty()) {
            for (BinaryLogClient.EventListener eventListener : eventListenerList) {
                if (eventListener instanceof BinlogEventListener) {
                    LOG.debug("Stopping checkpoint manager.");
                    ((BinlogEventListener)eventListener).stopCheckpointManager();
                }
                LOG.debug("Unregistering binlog event listeners.");
                this.binlogClient.unregisterEventListener(eventListener);
            }
        }
        LOG.debug("Unregistering binlog client lifecycle listeners.");
        this.binlogClient.getLifecycleListeners().forEach(arg_0 -> ((BinaryLogClient)this.binlogClient).unregisterLifecycleListener(arg_0));
        this.binlogClient.disconnect();
    }

    public BinaryLogClient getBinlogClient() {
        return this.binlogClient;
    }

    private void categorizeError(Exception e) {
        if (e instanceof AuthenticationException) {
            this.rdsSourceAggregateMetrics.getStream4xxErrors().increment();
            this.rdsSourceAggregateMetrics.getStreamAuthErrors().increment();
            LOG.error("Failed to connect to replication stream: Authentication failed. [{}]", (Object)e.getMessage());
        } else if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains(CONNECTION_REFUSED)) {
            this.rdsSourceAggregateMetrics.getStream4xxErrors().increment();
            this.rdsSourceAggregateMetrics.getStreamServerNotFoundErrors().increment();
            LOG.error("Failed to connect to replication stream: Cannot connect to MySQL server. [{}]", (Object)e.getMessage());
        } else if (e.getMessage() != null && e.getMessage().contains(FAILED_TO_DETERMINE_BINLOG_FILENAME)) {
            this.rdsSourceAggregateMetrics.getStream4xxErrors().increment();
            this.rdsSourceAggregateMetrics.getStreamReplicationNotEnabledErrors().increment();
            LOG.error("Failed to connect to replication stream: Binary logging not enabled on the server. [{}]", (Object)e.getMessage());
        } else if (e.getMessage() != null && e.getMessage().contains(ACCESS_DENIED)) {
            this.rdsSourceAggregateMetrics.getStream4xxErrors().increment();
            this.rdsSourceAggregateMetrics.getStreamAccessDeniedErrors().increment();
            LOG.error("Failed to connect to replication stream: Insufficient privileges. [{}]", (Object)e.getMessage());
        } else {
            this.rdsSourceAggregateMetrics.getStream5xxErrors().increment();
            LOG.error("Failed to connect to replication stream. ", (Throwable)e);
        }
    }
}

