/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.rds.model.ForeignKeyAction;
import org.opensearch.dataprepper.plugins.source.rds.model.ForeignKeyRelation;

public class ParentTable {
    private final String databaseName;
    private final String tableName;
    private final Map<String, List<ForeignKeyRelation>> referencedColumnMap;
    private Map<String, List<ForeignKeyRelation>> columnsWithCascadingUpdate;
    private Map<String, List<ForeignKeyRelation>> columnsWithCascadingDelete;

    public Map<String, List<ForeignKeyRelation>> getColumnsWithCascadingUpdate() {
        if (this.columnsWithCascadingUpdate != null) {
            return this.columnsWithCascadingUpdate;
        }
        this.columnsWithCascadingUpdate = new HashMap<String, List<ForeignKeyRelation>>();
        for (String column : this.referencedColumnMap.keySet()) {
            for (ForeignKeyRelation foreignKeyRelation : this.referencedColumnMap.get(column)) {
                if (!ForeignKeyAction.isCascadingAction(foreignKeyRelation.getUpdateAction())) continue;
                if (!this.columnsWithCascadingUpdate.containsKey(column)) {
                    this.columnsWithCascadingUpdate.put(column, new ArrayList());
                }
                this.columnsWithCascadingUpdate.get(column).add(foreignKeyRelation);
            }
        }
        return this.columnsWithCascadingUpdate;
    }

    public Map<String, List<ForeignKeyRelation>> getColumnsWithCascadingDelete() {
        if (this.columnsWithCascadingDelete != null) {
            return this.columnsWithCascadingDelete;
        }
        this.columnsWithCascadingDelete = new HashMap<String, List<ForeignKeyRelation>>();
        for (String column : this.referencedColumnMap.keySet()) {
            for (ForeignKeyRelation foreignKeyRelation : this.referencedColumnMap.get(column)) {
                if (!ForeignKeyAction.isCascadingAction(foreignKeyRelation.getDeleteAction())) continue;
                if (!this.columnsWithCascadingDelete.containsKey(column)) {
                    this.columnsWithCascadingDelete.put(column, new ArrayList());
                }
                this.columnsWithCascadingDelete.get(column).add(foreignKeyRelation);
            }
        }
        return this.columnsWithCascadingDelete;
    }

    private static Map<String, List<ForeignKeyRelation>> $default$columnsWithCascadingUpdate() {
        return null;
    }

    private static Map<String, List<ForeignKeyRelation>> $default$columnsWithCascadingDelete() {
        return null;
    }

    ParentTable(String databaseName, String tableName, Map<String, List<ForeignKeyRelation>> referencedColumnMap, Map<String, List<ForeignKeyRelation>> columnsWithCascadingUpdate, Map<String, List<ForeignKeyRelation>> columnsWithCascadingDelete) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.referencedColumnMap = referencedColumnMap;
        this.columnsWithCascadingUpdate = columnsWithCascadingUpdate;
        this.columnsWithCascadingDelete = columnsWithCascadingDelete;
    }

    public static ParentTableBuilder builder() {
        return new ParentTableBuilder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, List<ForeignKeyRelation>> getReferencedColumnMap() {
        return this.referencedColumnMap;
    }

    public static class ParentTableBuilder {
        private String databaseName;
        private String tableName;
        private Map<String, List<ForeignKeyRelation>> referencedColumnMap;
        private boolean columnsWithCascadingUpdate$set;
        private Map<String, List<ForeignKeyRelation>> columnsWithCascadingUpdate$value;
        private boolean columnsWithCascadingDelete$set;
        private Map<String, List<ForeignKeyRelation>> columnsWithCascadingDelete$value;

        ParentTableBuilder() {
        }

        public ParentTableBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public ParentTableBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ParentTableBuilder referencedColumnMap(Map<String, List<ForeignKeyRelation>> referencedColumnMap) {
            this.referencedColumnMap = referencedColumnMap;
            return this;
        }

        public ParentTableBuilder columnsWithCascadingUpdate(Map<String, List<ForeignKeyRelation>> columnsWithCascadingUpdate) {
            this.columnsWithCascadingUpdate$value = columnsWithCascadingUpdate;
            this.columnsWithCascadingUpdate$set = true;
            return this;
        }

        public ParentTableBuilder columnsWithCascadingDelete(Map<String, List<ForeignKeyRelation>> columnsWithCascadingDelete) {
            this.columnsWithCascadingDelete$value = columnsWithCascadingDelete;
            this.columnsWithCascadingDelete$set = true;
            return this;
        }

        public ParentTable build() {
            Map<String, List<ForeignKeyRelation>> columnsWithCascadingUpdate$value = this.columnsWithCascadingUpdate$value;
            if (!this.columnsWithCascadingUpdate$set) {
                columnsWithCascadingUpdate$value = ParentTable.$default$columnsWithCascadingUpdate();
            }
            Map<String, List<ForeignKeyRelation>> columnsWithCascadingDelete$value = this.columnsWithCascadingDelete$value;
            if (!this.columnsWithCascadingDelete$set) {
                columnsWithCascadingDelete$value = ParentTable.$default$columnsWithCascadingDelete();
            }
            return new ParentTable(this.databaseName, this.tableName, this.referencedColumnMap, columnsWithCascadingUpdate$value, columnsWithCascadingDelete$value);
        }

        public String toString() {
            return "ParentTable.ParentTableBuilder(databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", referencedColumnMap=" + String.valueOf(this.referencedColumnMap) + ", columnsWithCascadingUpdate$value=" + String.valueOf(this.columnsWithCascadingUpdate$value) + ", columnsWithCascadingDelete$value=" + String.valueOf(this.columnsWithCascadingDelete$value) + ")";
        }
    }
}

