/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.postgres;

import java.util.HashMap;
import java.util.Map;

public enum ColumnType {
    BOOLEAN(16, "bool"),
    SMALLINT(21, "int2"),
    INTEGER(23, "int4"),
    BIGINT(20, "int8"),
    REAL(700, "float4"),
    DOUBLE_PRECISION(701, "float8"),
    NUMERIC(1700, "numeric"),
    TEXT(25, "text"),
    BPCHAR(1042, "bpchar"),
    VARCHAR(1043, "varchar"),
    DATE(1082, "date"),
    TIME(1083, "time"),
    TIMETZ(1266, "timetz"),
    TIMESTAMP(1114, "timestamp"),
    TIMESTAMPTZ(1184, "timestamptz"),
    INTERVAL(1186, "interval"),
    JSON(114, "json"),
    JSONB(3802, "jsonb"),
    JSONPATH(4072, "jsonpath"),
    MONEY(790, "money"),
    BIT(1560, "bit"),
    VARBIT(1562, "varbit"),
    POINT(600, "point"),
    LINE(628, "line"),
    LSEG(601, "lseg"),
    BOX(603, "box"),
    PATH(602, "path"),
    POLYGON(604, "polygon"),
    CIRCLE(718, "circle"),
    CIDR(650, "cidr"),
    INET(869, "inet"),
    MACADDR(829, "macaddr"),
    MACADDR8(774, "macaddr8"),
    XML(142, "xml"),
    UUID(2950, "uuid"),
    PG_LSN(3220, "pg_lsn"),
    PG_SNAPSHOT(5038, "pg_snapshot"),
    TXID_SNAPSHOT(2970, "txid_snapshot"),
    TSVECTOR(3614, "tsvector"),
    TSQUERY(3615, "tsquery"),
    BYTEA(17, "bytea"),
    INT4RANGE(3904, "int4range"),
    INT8RANGE(3926, "int8range"),
    TSRANGE(3908, "tsrange"),
    TSTZRANGE(3910, "tstzrange"),
    DATERANGE(3912, "daterange"),
    NUMRANGE(3906, "numrange"),
    INT4MULTIRANGE(4451, "int4multirange"),
    INT8MULTIRANGE(4536, "int8multirange"),
    NUMMULTIRANGE(4532, "nummultirange"),
    DATEMULTIRANGE(4535, "datemultirange"),
    TSMULTIRANGE(4533, "tsmultirange"),
    TSTZMULTIRANGE(4534, "tstzmultirange"),
    INT2ARRAY(1005, "_int2"),
    INT4ARRAY(1007, "_int4"),
    INT8ARRAY(1016, "_int8"),
    NUMERICARRAY(1231, "_numeric"),
    FLOAT4ARRAY(1021, "_float4"),
    FLOAT8ARRAY(1022, "_float8"),
    MONEYARRAY(791, "_money"),
    TEXTARRAY(1009, "_text"),
    BPCHARARRAY(1014, "_bpchar"),
    VARCHARARRAY(1015, "_varchar"),
    BITARRAY(1561, "_bit"),
    VARBITARRAY(1563, "_varbit"),
    BOOLARRAY(1000, "_bool"),
    BYTEAARRAY(1001, "_bytea"),
    DATEARRAY(1182, "_date"),
    TIMEARRAY(1183, "_time"),
    TIMETZARRAY(1270, "_timetz"),
    TIMESTAMPARRAY(1115, "_timestamp"),
    TIMESTAMPTZARRAY(1185, "_timestamptz"),
    INTERVALARRAY(1187, "_interval"),
    POINTARRAY(1017, "_point"),
    LINEARRAY(629, "_line"),
    LSEGARRAY(1018, "_lseg"),
    BOXARRAY(1020, "_box"),
    PATHARRAY(1019, "_path"),
    POLYGONARRAY(1027, "_polygon"),
    CIRCLEARRAY(719, "_circle"),
    JSONARRAY(199, "_json"),
    JSONBARRAY(3807, "_jsonb"),
    CIDRARRAY(651, "_cidr"),
    INETARRAY(1041, "_inet"),
    MACADDRARRAY(1040, "_macaddr"),
    MACADDR8ARRAY(775, "_macaddr8"),
    UUIDARRAY(2951, "_uuid"),
    XMLARRAY(143, "_xml"),
    TSVECTORARRAY(3643, "_tsvector"),
    TSQUERYARRAY(3645, "_tsquery"),
    PG_LSNARRAY(3221, "_pg_lsn"),
    PG_SNAPSHOTARRAY(5039, "_pg_snapshot"),
    TXID_SNAPSHOTARRAY(2949, "_txid_snapshot"),
    NUMRANGEARRAY(3907, "_numrange"),
    INT4RANGEARRAY(3905, "_int4range"),
    INT8RANGEARRAY(3927, "_int8range"),
    TSRANGEARRAY(3909, "_tsrange"),
    TSTZRANGEARRAY(3911, "_tstzrange"),
    DATERANGEARRAY(3913, "_daterange"),
    INT4MULTIRANGEARRAY(6150, "_int4multirange"),
    INT8MULTIRANGEARRAY(6157, "_int8multirange"),
    NUMMULTIRANGEARRAY(6151, "_nummultirange"),
    DATEMULTIRANGEARRAY(6155, "_datemultirange"),
    TSMULTIRANGEARRAY(6152, "_tsmultirange"),
    TSTZMULTIRANGEARRAY(6153, "_tstzmultirange"),
    ENUM(-1, "enum"),
    UNKNOWN(-2, "unknown");

    public static final int ENUM_TYPE_ID = -1;
    public static final int UNKNOWN_TYPE_ID = -2;
    private final int typeId;
    private final String typeName;
    private static final Map<Integer, ColumnType> TYPE_ID_MAP;

    private ColumnType(int typeId, String typeName) {
        this.typeId = typeId;
        this.typeName = typeName;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static ColumnType getByTypeId(int typeId) {
        if (!TYPE_ID_MAP.containsKey(typeId)) {
            throw new IllegalArgumentException("Unsupported column type id: " + typeId);
        }
        return TYPE_ID_MAP.get(typeId);
    }

    public static String getTypeNameByEnum(ColumnType columnType) {
        return columnType.getTypeName();
    }

    static {
        TYPE_ID_MAP = new HashMap<Integer, ColumnType>();
        for (ColumnType type : ColumnType.values()) {
            TYPE_ID_MAP.put(type.typeId, type);
        }
    }
}

