/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.model;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum ExportStatus {
    CANCELED,
    CANCELING,
    COMPLETE,
    FAILED,
    IN_PROGRESS,
    STARTING;

    private static final Map<String, ExportStatus> TYPES_MAP;
    private static final Set<ExportStatus> TERMINAL_STATUSES;

    public static ExportStatus fromString(String name) {
        return TYPES_MAP.get(name);
    }

    public static boolean isTerminal(String name) {
        ExportStatus status = ExportStatus.fromString(name);
        return status != null && TERMINAL_STATUSES.contains((Object)status);
    }

    static {
        TYPES_MAP = Arrays.stream(ExportStatus.values()).collect(Collectors.toMap(Enum::name, value -> value));
        TERMINAL_STATUSES = Set.of(CANCELED, COMPLETE, FAILED);
    }
}

