/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.parse.json;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;
import org.opensearch.dataprepper.plugins.processor.parse.CommonParseConfig;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>parse_json</code> processor parses JSON data from fields in events.")
public class ParseJsonProcessorConfig
implements CommonParseConfig {
    static final String DEFAULT_SOURCE = "message";
    @NotBlank
    @JsonProperty(value="source", defaultValue="message")
    @JsonPropertyDescription(value="The field in the event that will be parsed. The default value is <code>message</code>.")
    private String source = "message";
    @JsonProperty(value="destination")
    @Pattern(regexp="^(?!\\s*$)(?!^/$).+", message="Cannot be an empty string, <code>/</code>, or any whitespace-only string")
    @JsonPropertyDescription(value="The destination field of the structured object from the parsed JSON. Defaults to the root of the event. Cannot be an empty string, <code>/</code>, or any whitespace-only string because these are not valid event fields.")
    private @Pattern(regexp="^(?!\\s*$)(?!^/$).+", message="Cannot be an empty string, <code>/</code>, or any whitespace-only string") String destination;
    @JsonProperty(value="depth", defaultValue="0")
    @Min(value=0L)
    @Max(value=10L)
    @JsonPropertyDescription(value="Indicates the depth at which the nested values of the event are not parsed any more. Default is 0, which means all levels of nested values are parsed. If the depth is 1, only the top level keys are parsed and all its nested values are represented as strings")
    private @Min(value=0L) @Max(value=10L) int depth = 0;
    @JsonProperty(value="pointer")
    @JsonPropertyDescription(value="A JSON pointer to the field to be parsed. There is no pointer by default, meaning the entire source is parsed. The pointer can access JSON array indexes as well. If the JSON pointer is invalid then the entire source data is parsed into the outgoing event. If the key that is pointed to already exists in the event and the destination is the root, then the pointer uses the entire path of the key.")
    @ExampleValues(value={@ExampleValues.Example(value="/example/pointer", description="The field at '/example/pointer' in the input data will be parsed if the pointer is valid.")})
    private String pointer;
    @JsonProperty(value="overwrite_if_destination_exists", defaultValue="true")
    @JsonPropertyDescription(value="Overwrites the destination if set to true. Set to false to prevent changing a destination value that exists. Defaults to true.")
    private boolean overwriteIfDestinationExists = true;
    @JsonProperty
    @JsonPropertyDescription(value="If true, the configured <code>source</code> field will be deleted after the JSON data is parsed into separate fields.")
    private boolean deleteSource = false;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A list of strings specifying the tags to be set in the event when the processor fails or an unknown exception occurs during parsing.")
    private List<String> tagsOnFailure;
    @JsonProperty(value="handle_failed_events")
    @JsonPropertyDescription(value="Determines how to handle events with JSON processing errors. Options include 'skip', which will log the error and send the event downstream to the next processor, and 'skip_silently', which will send the Event downstream to the next processor without logging the error. Default is 'skip'.")
    @NotNull
    private HandleFailedEventsOption handleFailedEventsOption = HandleFailedEventsOption.SKIP;
    @JsonProperty(value="parse_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a> such as <code>/some_key == \"test\"</code>. If specified, the <code>parse_json</code> processor will only run on events when the expression evaluates to true. ")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs parsing on the Event if some_key is null or doesn't exist.")})
    private String parseWhen;

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public String getPointer() {
        return this.pointer;
    }

    @Override
    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }

    @Override
    public String getParseWhen() {
        return this.parseWhen;
    }

    @Override
    public boolean getOverwriteIfDestinationExists() {
        return this.overwriteIfDestinationExists;
    }

    @Override
    public boolean isDeleteSourceRequested() {
        return this.deleteSource;
    }

    @Override
    public HandleFailedEventsOption getHandleFailedEventsOption() {
        return this.handleFailedEventsOption;
    }

    @AssertTrue(message="destination cannot be empty, whitespace, or a front slash (/)")
    @AssertTrue(message="destination cannot be empty, whitespace, or a front slash (/)") boolean isValidDestination() {
        if (Objects.isNull(this.destination)) {
            return true;
        }
        String trimmedDestination = this.destination.trim();
        return !trimmedDestination.isEmpty() && !trimmedDestination.equals("/");
    }

    @AssertTrue(message="handled_failed_events must be set to 'skip' or 'skip_silently'.")
    @AssertTrue(message="handled_failed_events must be set to 'skip' or 'skip_silently'.") boolean isHandleFailedEventsOptionValid() {
        if (this.handleFailedEventsOption == null) {
            return true;
        }
        return !this.handleFailedEventsOption.shouldDropEvent();
    }
}

