/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.oteltracegroup;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.nio.file.Path;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.processor.oteltracegroup.AuthConfig;
import org.opensearch.dataprepper.plugins.processor.oteltracegroup.AwsOption;
import software.amazon.awssdk.arns.Arn;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>otel_trace_group</code> processor completes missing trace-group-related fields in the collection of <a href=\"https://github.com/opensearch-project/data-prepper/blob/834f28fdf1df6d42a6666e91e6407474b88e7ec6/data-prepper-api/src/main/java/org/opensearch/dataprepper/model/trace/Span.java\">span</a> records by looking up the OpenSearch backend. The otel_trace_group processor identifies the missing trace group information for a spanId by looking up the relevant fields in its root <code>span</code> stored in OpenSearch.")
public class ConnectionConfiguration {
    private static final String AWS_IAM_ROLE = "role";
    private static final String AWS_IAM = "iam";
    private static final String DEFAULT_AWS_REGION = "us-east-1";
    static final String AOS_SERVICE_NAME = "es";
    public static final String HOSTS = "hosts";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SOCKET_TIMEOUT = "socket_timeout";
    public static final String CONNECT_TIMEOUT = "connect_timeout";
    public static final String CERT_PATH = "cert";
    public static final String INSECURE = "insecure";
    public static final String AUTHENTICATION = "authentication";
    public static final String AWS_OPTION = "aws";
    public static final String AWS_SIGV4 = "aws_sigv4";
    public static final String AWS_REGION = "aws_region";
    public static final String AWS_STS_ROLE_ARN = "aws_sts_role_arn";
    public static final String AWS_STS_EXTERNAL_ID = "aws_sts_external_id";
    public static final String AWS_STS_HEADER_OVERRIDES = "aws_sts_header_overrides";
    public static final String PROXY = "proxy";
    static final ValueRange VALID_PORT_RANGE = ValueRange.of(0L, 65535L);
    @NotEmpty
    @JsonProperty(value="hosts")
    @JsonPropertyDescription(value="A list of IP addresses of OpenSearch nodes.")
    private List<String> hosts;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="A string that contains the username and is used in the <a href=\"https://opensearch.org/docs/latest/security/access-control/users-roles/\">internal users</a> YAML configuration file of your OpenSearch cluster.")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="A string that contains the password and is used in the <a href=\"https://opensearch.org/docs/latest/security/access-control/users-roles/\">internal users</a> YAML configuration file of your OpenSearch cluster.")
    private String password;
    @JsonProperty(value="cert")
    @JsonPropertyDescription(value="A certificate authority (CA) certificate that is PEM encoded. Accepts both .pem or .crt. This enables the client to trust the CA that has signed the certificate that OpenSearch is using.")
    private Path certPath;
    @JsonProperty(value="socket_timeout")
    private Integer socketTimeout;
    @JsonProperty(value="connect_timeout")
    private Integer connectTimeout;
    @JsonProperty(value="insecure")
    private boolean insecure;
    @JsonProperty(value="aws_sigv4")
    @JsonPropertyDescription(value="A Boolean flag used to sign the HTTP request with AWS credentials. Only applies to Amazon OpenSearch Service. See <a href=\"https://github.com/opensearch-project/data-prepper/blob/129524227779ee35a327c27c3098d550d7256df1/data-prepper-plugins/opensearch/security.md\">OpenSearch security</a> for details.")
    private boolean awsSigv4;
    @JsonProperty(value="aws_region")
    @JsonPropertyDescription(value="A string that represents the AWS Region of the Amazon OpenSearch Service domain, for example, <code>us-west-2</code>. Only applies to Amazon OpenSearch Service.")
    private String awsRegion = "us-east-1";
    @JsonProperty(value="aws_sts_role_arn")
    @JsonPropertyDescription(value="An AWS Identity and Access Management (IAM) role that the sink plugin assumes to sign the request to Amazon OpenSearch Service. If not provided, the plugin uses the <a href=\"https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/auth/credentials/DefaultCredentialsProvider.html\">default credentials</a>.")
    @Size(max=2048, message="aws_sts_role_arn length cannot exceed 2048")
    private @Size(max=2048, message="aws_sts_role_arn length cannot exceed 2048") String awsStsRoleArn;
    @JsonProperty(value="aws")
    @JsonPropertyDescription(value="The <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/configuration/sinks/opensearch/#aws\">AWS</a> configuration.")
    private AwsOption awsOption;
    @JsonProperty(value="aws_sts_external_id")
    @Size(max=1224, message="aws_sts_external_id length cannot exceed 1224")
    @JsonPropertyDescription(value="The external ID to attach to AssumeRole requests from AWS STS.")
    private @Size(max=1224, message="aws_sts_external_id length cannot exceed 1224") String awsStsExternalId;
    @JsonProperty(value="aws_sts_header_overrides")
    @JsonPropertyDescription(value="A map of header overrides that the IAM role assumes for the plugin.")
    private Map<String, String> awsStsHeaderOverrides;
    @JsonProperty(value="proxy")
    @JsonPropertyDescription(value="The address of the <a href=\"https://en.wikipedia.org/wiki/Proxy_server\">forward HTTP proxy server</a>. The format is \"&lt;hostname or IP&gt;:&lt;port&gt;\" (for example, \"example.com:8100\", \"http://example.com:8100\", \"112.112.112.112:8100\"). The port number cannot be omitted.")
    private String proxy;
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="The basic authentication configuration.")
    private AuthConfig authConfig;

    List<String> getHosts() {
        return this.hosts;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    boolean isAwsSigv4() {
        return this.awsSigv4 || this.awsOption != null;
    }

    String getAwsRegion() {
        return this.awsRegion;
    }

    String getAwsStsRoleArn() {
        return this.awsStsRoleArn;
    }

    AwsOption getAwsOption() {
        return this.awsOption;
    }

    Path getCertPath() {
        return this.certPath;
    }

    String getProxy() {
        return this.proxy;
    }

    Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public String getAwsStsExternalId() {
        return this.awsStsExternalId;
    }

    public Map<String, String> getAwsStsHeaderOverrides() {
        return this.awsStsHeaderOverrides;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    @AssertTrue(message="Deprecated username and password should not be set when authentication is configured.")
    @AssertTrue(message="Deprecated username and password should not be set when authentication is configured.") boolean isValidAuthentication() {
        if (this.authConfig != null) {
            return this.username == null && this.password == null;
        }
        if (this.username != null || this.password != null) {
            return this.authConfig == null;
        }
        return true;
    }

    @AssertTrue(message="aws_sigv4 option cannot be used along with aws option.")
    @AssertTrue(message="aws_sigv4 option cannot be used along with aws option.") boolean isValidAwsAuth() {
        if (this.awsOption != null) {
            return !this.awsSigv4;
        }
        if (this.awsSigv4) {
            return this.awsOption == null;
        }
        return true;
    }

    @AssertTrue(message="sts_role_arn must be an null or a valid IAM role ARN.")
    @AssertTrue(message="sts_role_arn must be an null or a valid IAM role ARN.") boolean isValidStsRoleArn() {
        if (this.awsStsRoleArn == null) {
            return true;
        }
        Arn arn = this.getArn(this.awsStsRoleArn);
        if (!AWS_IAM.equals(arn.service())) {
            return false;
        }
        Optional resourceType = arn.resource().resourceType();
        return !resourceType.isEmpty() && ((String)resourceType.get()).equals(AWS_IAM_ROLE);
    }

    private Arn getArn(String awsStsRoleArn) {
        try {
            return Arn.fromString((String)awsStsRoleArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid ARN format for awsStsRoleArn. Check the format of %s", awsStsRoleArn));
        }
    }
}

