/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.oteltracegroup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.processor.oteltracegroup.ServerlessOptions;
import software.amazon.awssdk.arns.Arn;

public class AwsOption {
    public static final String REGION = "region";
    public static final String STS_ROLE_ARN = "sts_role_arn";
    public static final String STS_EXTERNAL_ID = "sts_external_id";
    public static final String STS_HEADER_OVERRIDES = "sts_header_overrides";
    public static final String SERVERLESS = "serverless";
    public static final String SERVERLESS_OPTIONS = "serverless_options";
    private static final String AWS_IAM = "iam";
    private static final String AWS_IAM_ROLE = "role";
    static final String DEFAULT_AWS_REGION = "us-east-1";
    @JsonProperty(value="serverless")
    private boolean serverless;
    @JsonProperty(value="region")
    @JsonPropertyDescription(value="A string that represents the AWS Region of the Amazon OpenSearch Service domain, for example, <code>us-west-2</code>. Only applies to Amazon OpenSearch Service.")
    private String region = "us-east-1";
    @JsonProperty(value="sts_role_arn")
    @JsonPropertyDescription(value="An AWS Identity and Access Management (IAM) role that the sink plugin assumes to sign the request to Amazon OpenSearch Service. If not provided, the plugin uses the <a href=\"https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/auth/credentials/DefaultCredentialsProvider.html\">default credentials</a>.")
    @Size(max=2048, message="sts_role_arn length cannot exceed 2048.")
    private @Size(max=2048, message="sts_role_arn length cannot exceed 2048.") String stsRoleArn;
    @JsonProperty(value="sts_external_id")
    @JsonPropertyDescription(value="The external ID to attach to AssumeRole requests from AWS STS.")
    private String stsExternalId;
    @JsonProperty(value="sts_header_overrides")
    @JsonPropertyDescription(value="A map of header overrides that the IAM role assumes for the plugin.")
    private Map<String, String> stsHeaderOverrides = Collections.emptyMap();
    @JsonProperty(value="serverless_options")
    @JsonPropertyDescription(value="The network configuration options available when the backend of the <code>opensearch</code> sink is set to Amazon OpenSearch Serverless.")
    private ServerlessOptions serverlessOptions;

    public String getRegion() {
        return this.region;
    }

    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    public String getStsExternalId() {
        return this.stsExternalId;
    }

    public Map<String, String> getStsHeaderOverrides() {
        return this.stsHeaderOverrides;
    }

    public boolean isServerless() {
        return this.serverless;
    }

    public ServerlessOptions getServerlessOptions() {
        return this.serverlessOptions;
    }

    @AssertTrue(message="sts_role_arn must be an null or a valid IAM role ARN.")
    @AssertTrue(message="sts_role_arn must be an null or a valid IAM role ARN.") boolean isValidStsRoleArn() {
        if (this.stsRoleArn == null) {
            return true;
        }
        Arn arn = this.getArn(this.stsRoleArn);
        if (!AWS_IAM.equals(arn.service())) {
            return false;
        }
        Optional resourceType = arn.resource().resourceType();
        return !resourceType.isEmpty() && ((String)resourceType.get()).equals(AWS_IAM_ROLE);
    }

    private Arn getArn(String awsStsRoleArn) {
        try {
            return Arn.fromString((String)awsStsRoleArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid ARN format for awsStsRoleArn. Check the format of %s", awsStsRoleArn));
        }
    }
}

