/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.obfuscation.action;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

@JsonClassDescription(value="Obfuscates data by performing a one-way hash.")
@JsonPropertyOrder
public class OneWayHashActionConfig {
    public static final String DEFAULT_FORMAT = "SHA-512";
    @JsonProperty(value="salt")
    @JsonPropertyDescription(value="Salt value to use when generating hash. If not specified, salt will be randomly generated by the processor.")
    @Size.List(value={@Size(min=16, message="Minimum size of salt string is 16."), @Size(max=64, message="Maximum size of salt string is 64")})
    private @Size.List(value={@Size(min=16, message="Minimum size of salt string is 16."), @Size(max=64, message="Maximum size of salt string is 64")}) String salt;
    @JsonProperty(value="salt_key")
    @JsonPropertyDescription(value="A key to compute salt based on a value provided as part of a record. If key or value was not found in the event, a salt defined in the pipeline configuration will be used instead.")
    @EventKeyConfiguration(value={EventKeyFactory.EventAction.GET})
    private EventKey saltKey;
    @JsonProperty(value="format", defaultValue="SHA-512")
    @Pattern(regexp="SHA-512", message="Valid values: <code>SHA-512</code>")
    @JsonPropertyDescription(value="Format of one way hash to generate. Default to <code>SHA-512</code>.")
    private @Pattern(regexp="SHA-512", message="Valid values: <code>SHA-512</code>") String format = "SHA-512";

    public String getSalt() {
        return this.salt;
    }

    public String getFormat() {
        return this.format;
    }

    public EventKey getSaltKey() {
        return this.saltKey;
    }
}

