/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.newline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventFactory;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.codec.newline.NewlineDelimitedInputConfig;

@DataPrepperPlugin(name="newline", pluginType=InputCodec.class, pluginConfigurationType=NewlineDelimitedInputConfig.class)
public class NewlineDelimitedInputCodec
implements InputCodec {
    private static final String MESSAGE_FIELD_NAME = "message";
    private final int skipLines;
    private final String headerDestination;

    @DataPrepperPluginConstructor
    public NewlineDelimitedInputCodec(NewlineDelimitedInputConfig config, EventFactory eventFactory) {
        Objects.requireNonNull(config);
        this.skipLines = config.getSkipLines();
        if (this.skipLines < 0) {
            throw new IllegalArgumentException("skipLines must be non-negative.");
        }
        this.headerDestination = config.getHeaderDestination();
    }

    public void parse(InputStream inputStream, Consumer<Record<Event>> eventConsumer) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            this.parseBufferedReader(reader, eventConsumer);
        }
    }

    private void parseBufferedReader(BufferedReader reader, Consumer<Record<Event>> eventConsumer) throws IOException {
        String line;
        boolean doAddHeaderToOutgoingEvents = Objects.nonNull(this.headerDestination);
        boolean hasReadHeader = false;
        String header = "";
        int linesToSkip = this.skipLines;
        while ((line = reader.readLine()) != null) {
            boolean shouldSkipThisLine;
            boolean shouldSkipBecauseThisLineIsHeader = doAddHeaderToOutgoingEvents && !hasReadHeader;
            boolean bl = shouldSkipThisLine = linesToSkip > 0 || shouldSkipBecauseThisLineIsHeader;
            if (shouldSkipThisLine) {
                if (linesToSkip > 0) {
                    --linesToSkip;
                    continue;
                }
                header = line;
                hasReadHeader = true;
                continue;
            }
            HashMap<String, String> eventData = new HashMap<String, String>();
            if (doAddHeaderToOutgoingEvents) {
                eventData.put(this.headerDestination, header);
            }
            eventData.put(MESSAGE_FIELD_NAME, line);
            JacksonEvent event = JacksonLog.builder().withData(eventData).build();
            eventConsumer.accept((Record<Event>)new Record((Object)event));
        }
    }
}

