/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.DeleteEntryProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="delete_entries", pluginType=Processor.class, pluginConfigurationType=DeleteEntryProcessorConfig.class)
public class DeleteEntryProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteEntryProcessor.class);
    private final List<EventKey> withKeys;
    private final String deleteWhen;
    private final List<DeleteEntryProcessorConfig.Entry> entries;
    private final ExpressionEvaluator expressionEvaluator;
    private final DeleteEntryProcessorConfig deleteEntryProcessorConfig;

    @DataPrepperPluginConstructor
    public DeleteEntryProcessor(PluginMetrics pluginMetrics, DeleteEntryProcessorConfig config, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.withKeys = config.getWithKeys();
        this.deleteEntryProcessorConfig = config;
        this.deleteWhen = config.getDeleteWhen();
        this.expressionEvaluator = expressionEvaluator;
        if (this.deleteWhen != null && !expressionEvaluator.isValidExpressionStatement(this.deleteWhen).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("delete_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", this.deleteWhen));
        }
        if (this.withKeys != null && !this.withKeys.isEmpty()) {
            DeleteEntryProcessorConfig.Entry entry2 = new DeleteEntryProcessorConfig.Entry(this.withKeys, this.deleteWhen, config.getIterateOn(), config.getDeleteFromElementWhen());
            this.entries = List.of(entry2);
        } else {
            this.entries = config.getEntries();
        }
        this.entries.forEach(entry -> {
            if (entry.getDeleteWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getDeleteWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("delete_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getDeleteWhen()));
            }
            if (entry.getIterateOn() == null && entry.getDeleteFromElementWhen() != null) {
                throw new InvalidPluginConfigurationException("delete_from_element_when only applies when iterate_on is configured.");
            }
            if (entry.getDeleteFromElementWhen() != null && !expressionEvaluator.isValidExpressionStatement(entry.getDeleteFromElementWhen()).booleanValue()) {
                throw new InvalidPluginConfigurationException(String.format("delete_from_element_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", entry.getDeleteFromElementWhen()));
            }
        });
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                for (DeleteEntryProcessorConfig.Entry entry : this.entries) {
                    if (Objects.nonNull(entry.getDeleteWhen()) && !this.expressionEvaluator.evaluateConditional(entry.getDeleteWhen(), recordEvent).booleanValue()) continue;
                    String iterateOn = this.deleteEntryProcessorConfig.getIterateOn();
                    if (Objects.isNull(iterateOn)) {
                        for (EventKey entryKey : entry.getWithKeys()) {
                            recordEvent.delete(entryKey);
                        }
                        continue;
                    }
                    this.handleForIterateOn(recordEvent, entry, iterateOn);
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private void handleForIterateOn(Event recordEvent, DeleteEntryProcessorConfig.Entry entry, String iterateOn) {
        List iterateOnList = (List)recordEvent.get(iterateOn, List.class);
        if (iterateOnList != null) {
            for (int i = 0; i < iterateOnList.size(); ++i) {
                Map item = (Map)iterateOnList.get(i);
                JacksonEvent context = JacksonEvent.builder().withEventMetadata(recordEvent.getMetadata()).withData((Object)item).build();
                if (entry.getDeleteFromElementWhen() != null && !this.expressionEvaluator.evaluateConditional(entry.getDeleteFromElementWhen(), (Event)context).booleanValue()) continue;
                for (EventKey entryKey : entry.getWithKeys()) {
                    context.delete(entryKey);
                }
                iterateOnList.set(i, context.toMap());
            }
            recordEvent.put(iterateOn, (Object)iterateOnList);
        }
    }
}

