/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.mutateevent.ConvertEntryTypeProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.mutateevent.TargetType;
import org.opensearch.dataprepper.typeconverter.ConverterArguments;
import org.opensearch.dataprepper.typeconverter.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="convert_type", deprecatedName="convert_entry_type", pluginType=Processor.class, pluginConfigurationType=ConvertEntryTypeProcessorConfig.class)
public class ConvertEntryTypeProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final Logger LOG = LoggerFactory.getLogger(ConvertEntryTypeProcessor.class);
    private final List<String> convertEntryKeys;
    private final TypeConverter<?> converter;
    private final String convertWhen;
    private final List<String> nullValues;
    private final String type;
    private final List<String> tagsOnFailure;
    private final String iterateOn;
    private int scale = 0;
    private final ExpressionEvaluator expressionEvaluator;
    private final ConverterArguments converterArguments;
    private List<DateTimeFormatter> coerceDateTimeFormatters;
    private final ConvertEntryTypeProcessorConfig.CoerceStringsConfig coerceStrings;

    @DataPrepperPluginConstructor
    public ConvertEntryTypeProcessor(PluginMetrics pluginMetrics, ConvertEntryTypeProcessorConfig convertEntryTypeProcessorConfig, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.converterArguments = convertEntryTypeProcessorConfig;
        this.convertEntryKeys = this.getKeysToConvert(convertEntryTypeProcessorConfig);
        TargetType targetType = convertEntryTypeProcessorConfig.getType();
        if (targetType != null) {
            this.type = targetType.name();
            this.converter = targetType.getTargetConverter();
        } else {
            this.type = null;
            this.converter = null;
        }
        this.scale = convertEntryTypeProcessorConfig.getScale();
        this.convertWhen = convertEntryTypeProcessorConfig.getConvertWhen();
        this.nullValues = convertEntryTypeProcessorConfig.getNullValues().orElse(List.of());
        this.expressionEvaluator = expressionEvaluator;
        this.tagsOnFailure = convertEntryTypeProcessorConfig.getTagsOnFailure();
        this.iterateOn = convertEntryTypeProcessorConfig.getIterateOn();
        this.coerceStrings = convertEntryTypeProcessorConfig.getCoerceStrings();
        if (this.coerceStrings != null) {
            this.coerceDateTimeFormatters = this.coerceStrings.getCoerceStringTimeFormats().stream().map(this::getSourceFormatter).collect(Collectors.toList());
        }
        if (this.convertWhen != null && !expressionEvaluator.isValidExpressionStatement(this.convertWhen).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("convert_when %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", this.convertWhen));
        }
    }

    private DateTimeFormatter getSourceFormatter(String pattern) {
        LocalDate localDateForDefaultValues = LocalDate.now(DEFAULT_ZONE_ID);
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.MONTH_OF_YEAR, localDateForDefaultValues.getMonthValue()).parseDefaulting(ChronoField.DAY_OF_MONTH, localDateForDefaultValues.getDayOfMonth()).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
        if (!pattern.contains("a") && !pattern.contains("k")) {
            dateTimeFormatterBuilder.parseDefaulting(ChronoField.HOUR_OF_DAY, 0L);
        }
        if (!pattern.contains("y") && !pattern.contains("u")) {
            dateTimeFormatterBuilder.parseDefaulting(ChronoField.YEAR_OF_ERA, localDateForDefaultValues.getYear());
        }
        return dateTimeFormatterBuilder.toFormatter(Locale.getDefault()).withZone(DEFAULT_ZONE_ID);
    }

    private void doAutoConversion(Event event, Map<String, Object> map, String keyPrefix) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object result = null;
            try {
                result = this.autoConvert(event, entry.getValue(), keyPrefix + entry.getKey() + "/");
                if (result == null) continue;
                event.put(keyPrefix + entry.getKey(), result);
            }
            catch (Exception exception) {}
        }
    }

    private Object autoConvert(Event event, Object objValue, String keyPrefix) {
        if (objValue instanceof String) {
            String str = (String)objValue;
            if (str.isEmpty()) {
                return null;
            }
            String lstr = str.toLowerCase();
            Character firstChar = Character.valueOf(str.charAt(0));
            if (lstr.equals("true") || lstr.equals("false")) {
                return Boolean.parseBoolean(lstr);
            }
            if (str.contains(":")) {
                for (DateTimeFormatter formatter : this.coerceDateTimeFormatters) {
                    try {
                        ZonedDateTime tmp = ZonedDateTime.parse(str, formatter);
                        long r = tmp.toInstant().toEpochMilli();
                        return r;
                    }
                    catch (Exception exception) {
                    }
                }
                return null;
            }
            if (lstr.contains(".") || lstr.contains("e")) {
                Double d = Double.parseDouble(lstr);
                return d;
            }
            if (Character.isDigit(firstChar.charValue()) || firstChar.charValue() == '-' || firstChar.charValue() == '+') {
                Long l = Long.parseLong(str);
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return l.intValue();
                }
                return l;
            }
        } else if (objValue instanceof Map) {
            this.doAutoConversion(event, (Map)objValue, keyPrefix);
        } else if (objValue instanceof List) {
            List listValue = (List)objValue;
            for (int i = 0; i < listValue.size(); ++i) {
                Object result = this.autoConvert(event, listValue.get(i), keyPrefix + Integer.toString(i) + "/");
                if (result == null) continue;
                event.put(keyPrefix + Integer.toString(i), result);
            }
        }
        return null;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event recordEvent = (Event)record.getData();
            try {
                if (Objects.nonNull(this.convertWhen) && !this.expressionEvaluator.evaluateConditional(this.convertWhen, recordEvent).booleanValue()) continue;
                if (this.coerceStrings != null) {
                    this.doAutoConversion(recordEvent, recordEvent.toMap(), "");
                }
                if (this.convertEntryKeys == null || this.convertEntryKeys.isEmpty()) continue;
                for (String key : this.convertEntryKeys) {
                    if (this.iterateOn != null) {
                        this.handleWithIterateOn(recordEvent, key);
                        continue;
                    }
                    Object keyVal = recordEvent.get(key, Object.class);
                    if (keyVal == null) continue;
                    if (!this.nullValues.contains(keyVal.toString())) {
                        try {
                            this.handleWithoutIterateOn(keyVal, recordEvent, key);
                        }
                        catch (RuntimeException e) {
                            LOG.error(DataPrepperMarkers.EVENT, "Unable to convert key: {} with value: {} to {}", new Object[]{key, keyVal, this.type, e});
                            recordEvent.getMetadata().addTags(this.tagsOnFailure);
                        }
                        continue;
                    }
                    recordEvent.delete(key);
                }
            }
            catch (Exception e) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("There was an exception while processing Event [{}]").addArgument((Object)recordEvent).setCause((Throwable)e).log();
                recordEvent.getMetadata().addTags(this.tagsOnFailure);
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private void handleWithoutIterateOn(Object keyVal, Event recordEvent, String key) {
        if (keyVal instanceof List || keyVal.getClass().isArray()) {
            Stream<Object> inputStream = keyVal.getClass().isArray() ? Arrays.stream((Object[])keyVal) : ((List)keyVal).stream();
            List replacementList = inputStream.map(i -> this.converter.convert(i, this.converterArguments)).collect(Collectors.toList());
            recordEvent.put(key, replacementList);
        } else {
            recordEvent.put(key, this.converter.convert(keyVal, this.converterArguments));
        }
    }

    private void handleWithIterateOn(Event recordEvent, String key) {
        List iterateOnList;
        try {
            iterateOnList = (List)recordEvent.get(this.iterateOn, List.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The value of '%s' must be a List of Map<String, Object>, but was incompatible: %s", this.iterateOn, e.getMessage()), e);
        }
        if (iterateOnList != null) {
            int listIndex = 0;
            for (Map item : iterateOnList) {
                Object value = null;
                try {
                    value = item.get(key);
                    if (value != null) {
                        item.put(key, this.converter.convert(value, this.converterArguments));
                    }
                }
                catch (RuntimeException e) {
                    LOG.error(DataPrepperMarkers.EVENT, "Unable to convert element {} with key: {} with value: {} to {}", new Object[]{listIndex, key, value, this.type, e});
                }
                ++listIndex;
            }
            recordEvent.put(this.iterateOn, (Object)iterateOnList);
        }
    }

    private List<String> getKeysToConvert(ConvertEntryTypeProcessorConfig convertEntryTypeProcessorConfig) {
        ConvertEntryTypeProcessorConfig.CoerceStringsConfig coerceStrings = convertEntryTypeProcessorConfig.getCoerceStrings();
        String key = convertEntryTypeProcessorConfig.getKey();
        List<String> keys = convertEntryTypeProcessorConfig.getKeys();
        if (key == null && keys == null && coerceStrings == null) {
            throw new IllegalArgumentException("key, keys, and coerceStrings all cannot be null. One must be provided.");
        }
        if (key != null && keys != null) {
            throw new IllegalArgumentException("key and keys cannot both be defined.");
        }
        if (key != null) {
            if (key.isEmpty()) {
                throw new IllegalArgumentException("key cannot be empty.");
            }
            return Collections.singletonList(key);
        }
        return keys;
    }
}

