/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.state.StreamProgressState;

public class StreamPartition
extends EnhancedSourcePartition<StreamProgressState> {
    public static final String PARTITION_TYPE = "STREAM";
    private final String collection;
    private final StreamProgressState state;

    public StreamPartition(String collection, StreamProgressState state) {
        this.collection = collection;
        this.state = state;
    }

    public StreamPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.collection = keySplits[0];
        this.state = (StreamProgressState)this.convertStringToPartitionProgressState(StreamProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.collection;
    }

    public Optional<StreamProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public String getCollection() {
        return this.collection;
    }
}

