/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.coordination.partition;

import java.time.Instant;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.state.ExportProgressState;

public class ExportPartition
extends EnhancedSourcePartition<ExportProgressState> {
    public static final String PARTITION_TYPE = "EXPORT";
    private final String collection;
    private final int partitionSize;
    private final Instant exportTime;
    private final ExportProgressState state;

    public ExportPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.collection = keySplits[0];
        this.partitionSize = Integer.parseInt(keySplits[1]);
        this.exportTime = Instant.ofEpochMilli(Long.parseLong(keySplits[2]));
        this.state = (ExportProgressState)this.convertStringToPartitionProgressState(ExportProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public ExportPartition(String collection, int partitionSize, Instant exportTime, ExportProgressState state) {
        this.collection = collection;
        this.partitionSize = partitionSize;
        this.exportTime = exportTime;
        this.state = state;
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.collection + "|" + this.partitionSize + "|" + this.exportTime.toEpochMilli();
    }

    public Optional<ExportProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public String getCollection() {
        return this.collection;
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public Instant getExportTime() {
        return this.exportTime;
    }
}

