/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.model.changestream.OperationType;
import java.time.Instant;
import java.util.Map;
import org.opensearch.dataprepper.model.document.JacksonDocument;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RecordConverter.class);
    private static final String DEFAULT_ACTION = OpenSearchBulkActions.INDEX.toString();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String collection;
    private final String dataType;

    public RecordConverter(String collection, String dataType) {
        this.collection = collection;
        this.dataType = dataType;
    }

    private String getAttributeValue(Map<String, Object> data, String attributeName) {
        if (data.containsKey(attributeName)) {
            Object value = data.get(attributeName);
            return String.valueOf(value);
        }
        return null;
    }

    public Event convert(String record, long eventCreateTimeEpochMillis, long eventVersionNumber, OperationType eventName, String primaryKeyBsonType) {
        Map<String, Object> data = this.convertToMap(record);
        JacksonEvent event = JacksonDocument.builder().withData(data).build();
        if (eventName != null) {
            Instant externalOriginationTime = Instant.ofEpochMilli(eventCreateTimeEpochMillis);
            event.getEventHandle().setExternalOriginationTime(externalOriginationTime);
            event.getMetadata().setExternalOriginationTime(externalOriginationTime);
        }
        EventMetadata eventMetadata = event.getMetadata();
        eventMetadata.setAttribute("ingestion_type", (Object)this.dataType);
        eventMetadata.setAttribute("documentdb_collection", (Object)this.collection);
        eventMetadata.setAttribute("documentdb_timestamp", (Object)eventCreateTimeEpochMillis);
        eventMetadata.setAttribute("documentdb_event_name", (Object)eventName);
        eventMetadata.setAttribute("opensearch_action", (Object)this.mapStreamEventNameToBulkAction(eventName));
        eventMetadata.setAttribute("document_version", (Object)eventVersionNumber);
        String partitionKey = this.getAttributeValue(data, "_id");
        eventMetadata.setAttribute("partition_key", (Object)partitionKey);
        eventMetadata.setAttribute("primary_key", (Object)partitionKey);
        eventMetadata.setAttribute("documentdb_id_bson_type", (Object)primaryKeyBsonType);
        return event;
    }

    public Event convert(String record, long eventCreationTimeMillis, long eventVersionNumber, String primaryKeyBsonType) {
        return this.convert(record, eventCreationTimeMillis, eventVersionNumber, null, primaryKeyBsonType);
    }

    private String mapStreamEventNameToBulkAction(OperationType streamEventName) {
        if (streamEventName == null) {
            return DEFAULT_ACTION;
        }
        switch (streamEventName) {
            case INSERT: 
            case UPDATE: 
            case REPLACE: {
                return OpenSearchBulkActions.INDEX.toString();
            }
            case DELETE: {
                return OpenSearchBulkActions.DELETE.toString();
            }
        }
        return DEFAULT_ACTION;
    }

    private Map<String, Object> convertToMap(String jsonData) {
        try {
            return (Map)MAPPER.readValue(jsonData, Map.class);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error converting json data into map.");
            return null;
        }
    }
}

