/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.converter;

import com.mongodb.client.model.changestream.OperationType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.plugins.mongo.converter.RecordConverter;

public class PartitionKeyRecordConverter
extends RecordConverter {
    public static final String S3_PATH_DELIMITER = "/";
    private List<String> partitionNames = new ArrayList<String>();
    private int partitionSize = 0;
    final String s3PathPrefix;

    public PartitionKeyRecordConverter(String collection, String partitionType, String s3PathPrefix) {
        super(collection, partitionType);
        this.s3PathPrefix = s3PathPrefix;
    }

    public void initializePartitions(List<String> partitionNames) {
        this.partitionNames = partitionNames;
        this.partitionSize = partitionNames.size();
    }

    @Override
    public Event convert(String record, long eventCreateTimeEpochMillis, long eventVersionNumber, OperationType eventName, String primaryKeyBsonType) {
        Event event = super.convert(record, eventCreateTimeEpochMillis, eventVersionNumber, eventName, primaryKeyBsonType);
        EventMetadata eventMetadata = event.getMetadata();
        String partitionKey = String.valueOf(eventMetadata.getAttribute("partition_key"));
        eventMetadata.setAttribute("s3_partition_key", (Object)(this.s3PathPrefix + S3_PATH_DELIMITER + this.hashKeyToPartition(partitionKey)));
        return event;
    }

    private String hashKeyToPartition(String key) {
        return this.partitionNames.get(this.hashKeyToIndex(key));
    }

    private int hashKeyToIndex(String key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(key.getBytes());
            int hashValue = PartitionKeyRecordConverter.bytesToInt(hashBytes);
            return Math.abs(hashValue) % this.partitionSize;
        }
        catch (NoSuchAlgorithmException e) {
            return -1;
        }
    }

    private static int bytesToInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4 && i < bytes.length; ++i) {
            result <<= 8;
            result |= bytes[i] & 0xFF;
        }
        return result;
    }
}

