/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;

public class S3FolderPartition
extends EnhancedSourcePartition<String> {
    public static final String PARTITION_TYPE = "S3_FOLDER";
    private final String bucketName;
    private final String pathPrefix;
    private final String region;
    private final String collection;
    private final int partitionCount;

    public S3FolderPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.collection = keySplits[0];
        this.bucketName = keySplits[1];
        this.pathPrefix = keySplits[2];
        this.partitionCount = Integer.parseInt(keySplits[3]);
        this.region = keySplits[4];
    }

    public S3FolderPartition(String bucketName, String pathPrefix, String region, String collection, int partitionCount) {
        this.bucketName = bucketName;
        this.pathPrefix = pathPrefix;
        this.region = region;
        this.collection = collection;
        this.partitionCount = partitionCount;
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.collection + "|" + this.bucketName + "|" + this.pathPrefix + "|" + this.partitionCount + "|" + this.region;
    }

    public Optional<String> getProgressState() {
        return Optional.empty();
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCollection() {
        return this.collection;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }
}

