/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365.service;

import io.micrometer.core.instrument.Counter;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365RestClient;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365SourceConfig;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.models.AuditLogsResponse;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.SaaSCrawlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class Office365Service {
    private static final Logger log = LoggerFactory.getLogger(Office365Service.class);
    private final Office365SourceConfig office365SourceConfig;
    private final Office365RestClient office365RestClient;
    private final Counter searchResultsFoundCounter;
    private final Counter windowRetryCounter;
    private static final Duration SEVEN_DAYS = Duration.ofDays(7L);

    public Office365Service(Office365SourceConfig office365SourceConfig, Office365RestClient office365RestClient, PluginMetrics pluginMetrics) {
        this.office365SourceConfig = office365SourceConfig;
        this.office365RestClient = office365RestClient;
        this.searchResultsFoundCounter = pluginMetrics.counter("searchResultsFound");
        this.windowRetryCounter = pluginMetrics.counter("windowRetry");
    }

    public void initializeSubscriptions() {
        this.office365RestClient.startSubscriptions();
    }

    public String getAuditLog(String contentUri) {
        return this.office365RestClient.getAuditLog(contentUri);
    }

    public AuditLogsResponse searchAuditLogs(String logType, Instant startTime, Instant endTime, String nextPageUri) {
        if (startTime == null || endTime == null) {
            throw new SaaSCrawlerException("startTime and endTime must not be null", false);
        }
        if (logType == null) {
            throw new SaaSCrawlerException("logType must not be null", false);
        }
        try {
            AuditLogsResponse response;
            if (nextPageUri != null) {
                return this.office365RestClient.searchAuditLogs(logType, startTime, endTime, nextPageUri);
            }
            Instant adjustedStartTime = startTime;
            Instant lookBackHoursAgo = Instant.now().minus(Duration.ofHours(this.office365SourceConfig.getLookBackHours()));
            if (startTime.isBefore(lookBackHoursAgo) && lookBackHoursAgo.isBefore(endTime)) {
                adjustedStartTime = lookBackHoursAgo;
            }
            if ((response = this.office365RestClient.searchAuditLogs(logType, adjustedStartTime, endTime, null)).getItems() != null) {
                this.searchResultsFoundCounter.increment((double)response.getItems().size());
            }
            return response;
        }
        catch (Exception e) {
            this.windowRetryCounter.increment();
            throw new SaaSCrawlerException(String.format("Failed to fetch logs for time window %s to %s for log type %s.", startTime, endTime, logType), (Throwable)e, true);
        }
    }
}

