/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.List;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.AwsAuthenticationConfig;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.ConsumerStrategy;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.KinesisStreamConfig;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.KinesisStreamPollingConfig;

public class KinesisSourceConfig {
    static final Duration DEFAULT_TIME_OUT_IN_MILLIS = Duration.ofMillis(1000L);
    static final int DEFAULT_NUMBER_OF_RECORDS_TO_ACCUMULATE = 100;
    static final Duration DEFAULT_SHARD_ACKNOWLEDGEMENT_TIMEOUT = Duration.ofMinutes(10L);
    static final Duration DEFAULT_INITIALIZATION_BACKOFF_TIME = Duration.ofMillis(1000L);
    static final int DEFAULT_MAX_INITIALIZATION_ATTEMPTS = Integer.MAX_VALUE;
    @JsonProperty(value="streams")
    @NotNull
    @Valid
    @Size(min=1, max=4, message="Provide 1-4 streams to read from.")
    private @NotNull @Valid @Size(min=1, max=4, message="Provide 1-4 streams to read from.") List<KinesisStreamConfig> streams;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationConfig awsAuthenticationConfig;
    @JsonProperty(value="buffer_timeout")
    private Duration bufferTimeout = DEFAULT_TIME_OUT_IN_MILLIS;
    @JsonProperty(value="records_to_accumulate")
    private int numberOfRecordsToAccumulate = 100;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;
    @JsonProperty(value="consumer_strategy")
    private ConsumerStrategy consumerStrategy = ConsumerStrategy.ENHANCED_FAN_OUT;
    @JsonProperty(value="polling")
    private KinesisStreamPollingConfig pollingConfig;
    @NotNull
    @JsonProperty(value="codec")
    private PluginModel codec;
    @JsonProperty(value="shard_acknowledgment_timeout")
    private Duration shardAcknowledgmentTimeout = DEFAULT_SHARD_ACKNOWLEDGEMENT_TIMEOUT;
    @JsonProperty(value="max_initialization_attempts")
    private int maxInitializationAttempts = Integer.MAX_VALUE;
    @JsonProperty(value="initialization_backoff_time")
    private Duration initializationBackoffTime = DEFAULT_INITIALIZATION_BACKOFF_TIME;

    public Duration getShardAcknowledgmentTimeout() {
        return this.shardAcknowledgmentTimeout;
    }

    public List<KinesisStreamConfig> getStreams() {
        return this.streams;
    }

    public AwsAuthenticationConfig getAwsAuthenticationConfig() {
        return this.awsAuthenticationConfig;
    }

    public Duration getBufferTimeout() {
        return this.bufferTimeout;
    }

    public int getNumberOfRecordsToAccumulate() {
        return this.numberOfRecordsToAccumulate;
    }

    public boolean isAcknowledgments() {
        return this.acknowledgments;
    }

    public ConsumerStrategy getConsumerStrategy() {
        return this.consumerStrategy;
    }

    public KinesisStreamPollingConfig getPollingConfig() {
        return this.pollingConfig;
    }

    public PluginModel getCodec() {
        return this.codec;
    }

    public int getMaxInitializationAttempts() {
        return this.maxInitializationAttempts;
    }

    public Duration getInitializationBackoffTime() {
        return this.initializationBackoffTime;
    }
}

