/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.processor;

import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class KinesisCheckpointerRecord {
    private RecordProcessorCheckpointer checkpointer;
    private ExtendedSequenceNumber extendedSequenceNumber;
    private boolean readyToCheckpoint;

    KinesisCheckpointerRecord(RecordProcessorCheckpointer checkpointer, ExtendedSequenceNumber extendedSequenceNumber, boolean readyToCheckpoint) {
        this.checkpointer = checkpointer;
        this.extendedSequenceNumber = extendedSequenceNumber;
        this.readyToCheckpoint = readyToCheckpoint;
    }

    public static KinesisCheckpointerRecordBuilder builder() {
        return new KinesisCheckpointerRecordBuilder();
    }

    public RecordProcessorCheckpointer getCheckpointer() {
        return this.checkpointer;
    }

    public ExtendedSequenceNumber getExtendedSequenceNumber() {
        return this.extendedSequenceNumber;
    }

    public boolean isReadyToCheckpoint() {
        return this.readyToCheckpoint;
    }

    public void setCheckpointer(RecordProcessorCheckpointer checkpointer) {
        this.checkpointer = checkpointer;
    }

    public void setExtendedSequenceNumber(ExtendedSequenceNumber extendedSequenceNumber) {
        this.extendedSequenceNumber = extendedSequenceNumber;
    }

    public void setReadyToCheckpoint(boolean readyToCheckpoint) {
        this.readyToCheckpoint = readyToCheckpoint;
    }

    public static class KinesisCheckpointerRecordBuilder {
        private RecordProcessorCheckpointer checkpointer;
        private ExtendedSequenceNumber extendedSequenceNumber;
        private boolean readyToCheckpoint;

        KinesisCheckpointerRecordBuilder() {
        }

        public KinesisCheckpointerRecordBuilder checkpointer(RecordProcessorCheckpointer checkpointer) {
            this.checkpointer = checkpointer;
            return this;
        }

        public KinesisCheckpointerRecordBuilder extendedSequenceNumber(ExtendedSequenceNumber extendedSequenceNumber) {
            this.extendedSequenceNumber = extendedSequenceNumber;
            return this;
        }

        public KinesisCheckpointerRecordBuilder readyToCheckpoint(boolean readyToCheckpoint) {
            this.readyToCheckpoint = readyToCheckpoint;
            return this;
        }

        public KinesisCheckpointerRecord build() {
            return new KinesisCheckpointerRecord(this.checkpointer, this.extendedSequenceNumber, this.readyToCheckpoint);
        }

        public String toString() {
            return "KinesisCheckpointerRecord.KinesisCheckpointerRecordBuilder(checkpointer=" + String.valueOf(this.checkpointer) + ", extendedSequenceNumber=" + String.valueOf(this.extendedSequenceNumber) + ", readyToCheckpoint=" + this.readyToCheckpoint + ")";
        }
    }
}

