/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.kinesis.source.processor.KinesisCheckpointerRecord;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class KinesisCheckpointerTracker {
    private final Map<ExtendedSequenceNumber, KinesisCheckpointerRecord> checkpointerRecordList = new LinkedHashMap<ExtendedSequenceNumber, KinesisCheckpointerRecord>();

    public synchronized void addRecordForCheckpoint(ExtendedSequenceNumber extendedSequenceNumber, RecordProcessorCheckpointer checkpointer) {
        this.checkpointerRecordList.put(extendedSequenceNumber, KinesisCheckpointerRecord.builder().extendedSequenceNumber(extendedSequenceNumber).checkpointer(checkpointer).readyToCheckpoint(false).build());
    }

    public synchronized void markSequenceNumberForCheckpoint(ExtendedSequenceNumber extendedSequenceNumber) {
        if (!this.checkpointerRecordList.containsKey(extendedSequenceNumber)) {
            throw new IllegalArgumentException("checkpointer not available");
        }
        this.checkpointerRecordList.get(extendedSequenceNumber).setReadyToCheckpoint(true);
    }

    public synchronized Optional<KinesisCheckpointerRecord> popLatestReadyToCheckpointRecord() {
        Map.Entry<ExtendedSequenceNumber, KinesisCheckpointerRecord> entry;
        KinesisCheckpointerRecord kinesisCheckpointerRecord;
        Optional<KinesisCheckpointerRecord> kinesisCheckpointerRecordOptional = Optional.empty();
        ArrayList<ExtendedSequenceNumber> toRemoveRecords = new ArrayList<ExtendedSequenceNumber>();
        Iterator<Map.Entry<Object, KinesisCheckpointerRecord>> iterator = this.checkpointerRecordList.entrySet().iterator();
        while (iterator.hasNext() && (kinesisCheckpointerRecord = (entry = iterator.next()).getValue()).isReadyToCheckpoint()) {
            kinesisCheckpointerRecordOptional = Optional.of(kinesisCheckpointerRecord);
            toRemoveRecords.add(entry.getKey());
        }
        for (ExtendedSequenceNumber extendedSequenceNumber : toRemoveRecords) {
            this.checkpointerRecordList.remove(extendedSequenceNumber);
        }
        return kinesisCheckpointerRecordOptional;
    }

    public synchronized int size() {
        return this.checkpointerRecordList.size();
    }
}

