/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.time.Duration;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.kinesis.source.configuration.InitialPositionInStreamConfig;
import software.amazon.awssdk.arns.Arn;
import software.amazon.kinesis.common.InitialPositionInStream;

public class KinesisStreamConfig {
    private static final Duration MINIMAL_CHECKPOINT_INTERVAL = Duration.ofMillis(120000L);
    private static final boolean DEFAULT_ENABLE_CHECKPOINT = false;
    @JsonProperty(value="stream_name")
    @Valid
    private String name;
    @JsonProperty(value="stream_arn")
    @Valid
    private String streamArn;
    @JsonProperty(value="consumer_arn")
    @Valid
    private String consumerArn;
    @JsonProperty(value="initial_position")
    private InitialPositionInStreamConfig initialPosition = InitialPositionInStreamConfig.LATEST;
    @JsonProperty(value="checkpoint_interval")
    private Duration checkPointInterval = MINIMAL_CHECKPOINT_INTERVAL;
    @JsonProperty(value="compression")
    private CompressionOption compression = CompressionOption.NONE;

    public InitialPositionInStream getInitialPosition() {
        return this.initialPosition.getPositionInStream();
    }

    public String getStreamArn() {
        if (Objects.nonNull(this.streamArn) && !this.streamArn.isEmpty()) {
            try {
                Arn.fromString((String)this.streamArn);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid ARN format for stream arn");
            }
        }
        return this.streamArn;
    }

    public String getConsumerArn() {
        if (Objects.nonNull(this.consumerArn) && !this.consumerArn.isEmpty()) {
            try {
                Arn.fromString((String)this.consumerArn);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid ARN format for consumer arn");
            }
        }
        return this.consumerArn;
    }

    public String getName() {
        return this.name;
    }

    public Duration getCheckPointInterval() {
        return this.checkPointInterval;
    }

    public CompressionOption getCompression() {
        return this.compression;
    }
}

