/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum MessageFormat {
    PLAINTEXT("plaintext"),
    JSON("json"),
    AVRO("avro"),
    BYTES("bytes");

    private static final Map<String, MessageFormat> MESSAGE_FORMAT_MAP;
    private final String type;

    private MessageFormat(String type) {
        this.type = type;
    }

    @JsonCreator
    public static MessageFormat getByMessageFormatByName(String name) {
        return MESSAGE_FORMAT_MAP.get(name.toLowerCase());
    }

    static {
        MESSAGE_FORMAT_MAP = Arrays.stream(MessageFormat.values()).collect(Collectors.toMap(value -> value.type, value -> value));
    }
}

