/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.consumer;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;

public class TopicEmptinessMetadata {
    static final long IS_EMPTY_CHECK_INTERVAL_MS = 60000L;
    private long lastIsEmptyCheckTime = 0L;
    private Long topicEmptyCheckingOwnerThreadId = null;
    private ConcurrentHashMap<TopicPartition, Boolean> topicPartitionToIsEmpty = new ConcurrentHashMap();

    public void setLastIsEmptyCheckTime(long timestamp) {
        this.lastIsEmptyCheckTime = timestamp;
    }

    public void setTopicEmptyCheckingOwnerThreadId(Long threadId) {
        this.topicEmptyCheckingOwnerThreadId = threadId;
    }

    public void updateTopicEmptinessStatus(TopicPartition topicPartition, Boolean isEmpty) {
        this.topicPartitionToIsEmpty.put(topicPartition, isEmpty);
    }

    public long getLastIsEmptyCheckTime() {
        return this.lastIsEmptyCheckTime;
    }

    public Long getTopicEmptyCheckingOwnerThreadId() {
        return this.topicEmptyCheckingOwnerThreadId;
    }

    public ConcurrentHashMap<TopicPartition, Boolean> getTopicPartitionToIsEmpty() {
        return this.topicPartitionToIsEmpty;
    }

    public boolean isTopicEmpty() {
        return this.topicPartitionToIsEmpty.values().stream().allMatch(isEmpty -> isEmpty);
    }

    public boolean isWithinCheckInterval(long epochTimestamp) {
        return epochTimestamp < this.lastIsEmptyCheckTime + 60000L;
    }
}

