/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum IsolationLevel {
    READ_UNCOMMITTED("read_uncommitted"),
    READ_COMMITTED("read_committed");

    private static final Map<String, IsolationLevel> OPTIONS_MAP;
    private final String type;

    private IsolationLevel(String type) {
        this.type = type;
    }

    @JsonCreator
    public static IsolationLevel fromTypeValue(String type) {
        return OPTIONS_MAP.get(type.toLowerCase());
    }

    public String getType() {
        return this.type;
    }

    static {
        OPTIONS_MAP = Arrays.stream(IsolationLevel.values()).collect(Collectors.toMap(value -> value.type, value -> value));
    }
}

