/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.consumer;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPartitionCommitTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TopicPartitionCommitTracker.class);
    private long committedOffset;
    private long committedRecordCount;
    private long initialOffset;
    private final TopicPartition topicPartition;
    private final Map<Long, Range<Long>> offsetMaxMap;
    private final Map<Long, Range<Long>> offsetMinMap;

    public TopicPartitionCommitTracker(TopicPartition topicPartition, Long initialOffset) {
        this.topicPartition = topicPartition;
        this.initialOffset = initialOffset;
        LOG.info("Created commit tracker for partition: {}, initialOffset: {}", (Object)topicPartition, (Object)initialOffset);
        this.committedOffset = initialOffset - 1L;
        this.committedRecordCount = 0L;
        this.offsetMaxMap = new HashMap<Long, Range<Long>>();
        this.offsetMinMap = new HashMap<Long, Range<Long>>();
        this.offsetMaxMap.put(this.committedOffset, (Range<Long>)Range.between((Comparable)Long.valueOf(this.committedOffset), (Comparable)Long.valueOf(this.committedOffset)));
    }

    public long getInitialOffset() {
        return this.initialOffset;
    }

    public long getCommittedOffset() {
        return this.committedOffset;
    }

    public long getCommittedRecordCount() {
        long count = this.committedRecordCount;
        this.committedRecordCount = 0L;
        return count;
    }

    public TopicPartitionCommitTracker(String topic, int partition, Long committedOffset) {
        this(new TopicPartition(topic, partition), committedOffset);
    }

    public OffsetAndMetadata addCompletedOffsets(Range<Long> offsetRange) {
        Long maxValue;
        Range newEntry;
        Range<Long> entry;
        Long min = (Long)offsetRange.getMinimum();
        Long max = (Long)offsetRange.getMaximum();
        boolean merged = false;
        if (this.offsetMaxMap.containsKey(min - 1L)) {
            entry = this.offsetMaxMap.get(min - 1L);
            this.offsetMaxMap.remove(min - 1L);
            this.offsetMinMap.remove(entry.getMinimum());
            min = (Long)entry.getMinimum();
            newEntry = Range.between((Comparable)min, (Comparable)max);
            this.offsetMaxMap.put(max, (Range<Long>)newEntry);
            this.offsetMinMap.put(min, (Range<Long>)newEntry);
            merged = true;
        }
        if (this.offsetMinMap.containsKey(max + 1L)) {
            entry = this.offsetMinMap.get(max + 1L);
            this.offsetMinMap.remove(max + 1L);
            if (merged) {
                this.offsetMinMap.remove(min);
                this.offsetMaxMap.remove(max);
            }
            max = (Long)entry.getMaximum();
            this.offsetMaxMap.remove(max);
            newEntry = Range.between((Comparable)min, (Comparable)max);
            this.offsetMaxMap.put(max, (Range<Long>)newEntry);
            this.offsetMinMap.put(min, (Range<Long>)newEntry);
            merged = true;
        }
        if (!merged) {
            this.offsetMaxMap.put(max, offsetRange);
            this.offsetMinMap.put(min, offsetRange);
            return null;
        }
        if (this.offsetMinMap.containsKey(this.committedOffset) && (maxValue = (Long)this.offsetMinMap.get(this.committedOffset).getMaximum()) != this.committedOffset) {
            this.offsetMinMap.remove(this.committedOffset);
            this.committedRecordCount += maxValue - this.committedOffset;
            this.committedOffset = maxValue;
            this.offsetMaxMap.put(this.committedOffset, (Range<Long>)Range.between((Comparable)Long.valueOf(this.committedOffset), (Comparable)Long.valueOf(this.committedOffset)));
            return new OffsetAndMetadata(this.committedOffset + 1L);
        }
        return null;
    }
}

