/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SchemaRegistryType {
    AWS_GLUE("aws_glue"),
    CONFLUENT("confluent");

    private static final Map<String, SchemaRegistryType> OPTIONS_MAP;
    private final String type;

    private SchemaRegistryType(String type) {
        this.type = type;
    }

    @JsonCreator
    static SchemaRegistryType fromTypeValue(String type) {
        return OPTIONS_MAP.get(type.toLowerCase());
    }

    static {
        OPTIONS_MAP = Arrays.stream(SchemaRegistryType.values()).collect(Collectors.toMap(value -> value.type, value -> value));
    }
}

