/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.key;

import java.util.List;
import java.util.function.Supplier;
import org.opensearch.dataprepper.plugins.kafka.common.aws.AwsContext;
import org.opensearch.dataprepper.plugins.kafka.common.key.InnerKeyProvider;
import org.opensearch.dataprepper.plugins.kafka.common.key.KmsKeyProvider;
import org.opensearch.dataprepper.plugins.kafka.common.key.UnencryptedKeyProvider;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConfig;

public class KeyFactory {
    private final List<InnerKeyProvider> orderedKeyProviders;

    public KeyFactory(AwsContext awsContext) {
        this(List.of(new KmsKeyProvider(awsContext), new UnencryptedKeyProvider()));
    }

    KeyFactory(List<InnerKeyProvider> orderedKeyProviders) {
        this.orderedKeyProviders = orderedKeyProviders;
    }

    public Supplier<byte[]> getKeySupplier(TopicConfig topicConfig) {
        if (topicConfig.getEncryptionKey() == null) {
            return null;
        }
        InnerKeyProvider keyProvider = this.getInnerKeyProvider(topicConfig);
        return () -> (byte[])keyProvider.apply(topicConfig);
    }

    public String getEncryptedDataKey(TopicConfig topicConfig) {
        if (topicConfig.getEncryptionKey() == null) {
            return null;
        }
        InnerKeyProvider keyProvider = this.getInnerKeyProvider(topicConfig);
        if (keyProvider.isKeyEncrypted()) {
            return topicConfig.getEncryptionKey();
        }
        return null;
    }

    private InnerKeyProvider getInnerKeyProvider(TopicConfig topicConfig) {
        return this.orderedKeyProviders.stream().filter(innerKeyProvider -> innerKeyProvider.supportsConfiguration(topicConfig)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find an inner key provider. This is a programming error - UnencryptedKeyProvider should always work."));
    }
}

