/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common;

import java.util.function.Supplier;
import org.opensearch.dataprepper.plugins.kafka.common.KafkaDataConfig;
import org.opensearch.dataprepper.plugins.kafka.common.key.KeyFactory;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConfig;
import org.opensearch.dataprepper.plugins.kafka.util.MessageFormat;

public class KafkaDataConfigAdapter
implements KafkaDataConfig {
    private final KeyFactory keyFactory;
    private final TopicConfig topicConfig;

    public KafkaDataConfigAdapter(KeyFactory keyFactory, TopicConfig topicConfig) {
        this.keyFactory = keyFactory;
        this.topicConfig = topicConfig;
    }

    @Override
    public MessageFormat getSerdeFormat() {
        return this.topicConfig.getSerdeFormat();
    }

    @Override
    public Supplier<byte[]> getEncryptionKeySupplier() {
        if (this.topicConfig.getEncryptionKey() == null) {
            return null;
        }
        return this.keyFactory.getKeySupplier(this.topicConfig);
    }

    @Override
    public String getEncryptionId() {
        return this.topicConfig.getEncryptionId();
    }

    @Override
    public String getEncryptedDataKey() {
        if (this.topicConfig.getEncryptionKey() == null) {
            return null;
        }
        return this.keyFactory.getEncryptedDataKey(this.topicConfig);
    }
}

