/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.serialization;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.kafka.common.serialization.Serializer;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.EncryptionContext;

class EncryptionSerializer<T>
implements Serializer<T> {
    private final Serializer<T> innerSerializer;
    private final Cipher cipher;
    private final EncryptionContext encryptionContext;

    EncryptionSerializer(Serializer<T> innerSerializer, EncryptionContext encryptionContext) throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        this.innerSerializer = innerSerializer;
        this.cipher = encryptionContext.createEncryptionCipher();
        this.encryptionContext = encryptionContext;
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        byte[] unencryptedBytes = this.innerSerializer.serialize(topic, data);
        try {
            return this.cipher.doFinal(unencryptedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public EncryptionContext getEncryptionContext() {
        return this.encryptionContext;
    }

    public Serializer<T> getInnerSerializer() {
        return this.innerSerializer;
    }
}

