/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.serialization;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.opensearch.dataprepper.plugins.kafka.common.KafkaDataConfig;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.EncryptionSerializationFactory;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.MessageFormatSerializationFactory;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.SerializationFactory;

public class CommonSerializationFactory
implements SerializationFactory {
    private final MessageFormatSerializationFactory messageFormatSerializationFactory;
    private final EncryptionSerializationFactory encryptionSerializationFactory;

    public CommonSerializationFactory() {
        this(new MessageFormatSerializationFactory(), new EncryptionSerializationFactory());
    }

    CommonSerializationFactory(MessageFormatSerializationFactory messageFormatSerializationFactory, EncryptionSerializationFactory encryptionSerializationFactory) {
        this.messageFormatSerializationFactory = messageFormatSerializationFactory;
        this.encryptionSerializationFactory = encryptionSerializationFactory;
    }

    @Override
    public Deserializer<?> getDeserializer(KafkaDataConfig dataConfig) {
        Deserializer<?> deserializer = this.messageFormatSerializationFactory.getDeserializer(dataConfig.getSerdeFormat());
        return this.encryptionSerializationFactory.getDeserializer(dataConfig, deserializer);
    }

    @Override
    public Serializer<?> getSerializer(KafkaDataConfig dataConfig) {
        Serializer<?> serializer = this.messageFormatSerializationFactory.getSerializer(dataConfig.getSerdeFormat());
        return this.encryptionSerializationFactory.getSerializer(dataConfig, serializer);
    }
}

