/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.buffer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.plugins.kafka.buffer.BufferTopicConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.AwsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.EncryptionConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerProperties;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConsumerConfig;

class KafkaBufferConfig
implements KafkaProducerConfig,
KafkaConsumerConfig {
    private static final Duration DEFAULT_DRAIN_TIMEOUT = Duration.ofSeconds(30L);
    @JsonProperty(value="bootstrap_servers")
    private List<String> bootstrapServers;
    @JsonProperty(value="topics")
    @NotNull
    @Size(min=1, max=1, message="Only one topic currently supported for Kafka buffer")
    private @NotNull @Size(min=1, max=1, message="Only one topic currently supported for Kafka buffer") List<BufferTopicConfig> topics;
    @Valid
    @JsonProperty(value="authentication")
    private AuthConfig authConfig;
    @JsonProperty(value="encryption")
    private EncryptionConfig encryptionConfig;
    @JsonProperty(value="producer_properties")
    private KafkaProducerProperties kafkaProducerProperties;
    @JsonProperty(value="aws")
    @Valid
    private AwsConfig awsConfig;
    @JsonProperty(value="drain_timeout")
    private Duration drainTimeout = DEFAULT_DRAIN_TIMEOUT;
    @JsonProperty(value="custom_metric_prefix")
    private String customMetricPrefix;

    KafkaBufferConfig() {
    }

    public List<String> getBootstrapServers() {
        if (Objects.nonNull(this.bootstrapServers)) {
            return this.bootstrapServers;
        }
        return null;
    }

    @Override
    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    @Override
    @JsonIgnore
    public SchemaConfig getSchemaConfig() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getSerdeFormat() {
        return this.getTopic().getSerdeFormat().toString();
    }

    @Override
    @JsonIgnore
    public BufferTopicConfig getTopic() {
        return this.topics.get(0);
    }

    public List<? extends TopicConsumerConfig> getTopics() {
        return this.topics;
    }

    @Override
    public KafkaProducerProperties getKafkaProducerProperties() {
        return this.kafkaProducerProperties;
    }

    @Override
    @JsonIgnore
    public String getPartitionKey() {
        return "pipeline-buffer";
    }

    @Override
    @JsonIgnore
    public Optional<PluginModel> getDlq() {
        return Optional.empty();
    }

    @Override
    @JsonIgnore
    public void setDlqConfig(PluginSetting pluginSetting) {
    }

    @Override
    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    @Override
    public EncryptionConfig getEncryptionConfig() {
        if (Objects.isNull(this.encryptionConfig)) {
            return new EncryptionConfig();
        }
        return this.encryptionConfig;
    }

    @Override
    @JsonIgnore
    public String getClientDnsLookup() {
        return null;
    }

    @Override
    @JsonIgnore
    public boolean getAcknowledgementsEnabled() {
        return true;
    }

    public Duration getDrainTimeout() {
        return this.drainTimeout;
    }

    @JsonIgnore
    public Optional<String> getCustomMetricPrefix() {
        return Optional.ofNullable(this.customMetricPrefix);
    }
}

